% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{hd}
\alias{hd}
\title{Hamming Distance}
\usage{
hd(cg1, cg2, normalized = FALSE)
}
\arguments{
\item{cg1}{A \code{caugi} object.}

\item{cg2}{A \code{caugi} object.}

\item{normalized}{Logical; if \code{TRUE}, returns the normalized Hamming
Distance.}
}
\value{
An integer representing the Hamming Distance between the two graphs,
if \code{normalized = FALSE}, or a numeric between 0 and 1 if \code{normalized = TRUE}.
}
\description{
Compute the Hamming Distance between two graphs.
}
\examples{
cg1 <- caugi(A \%-->\% B \%-->\% C, D \%-->\% C, class = "DAG")
cg2 <- caugi(A \%-->\% B \%-->\% C, D \%---\% C, class = "PDAG")
hd(cg1, cg2) # 0

}
\seealso{
Other metrics: 
\code{\link{aid}()},
\code{\link{shd}()}
}
\concept{metrics}
