% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{num_data}
\alias{num_data}
\title{Simulated Numerical Data}
\format{
A data.frame with 1000 rows and 5 variables.
\describe{
\item{X1}{Structural equation: \eqn{X_1 := \sqrt{Z} + \epsilon_1} with \eqn{\epsilon_1 \sim \mathrm{Unif}[0, 2]}}
\item{X2}{Structural equation: \eqn{X_2 := 2 \cdot X_3 - \epsilon_2} with \eqn{\epsilon_2 \sim N(5, 1)}}
\item{X3}{Structural equation: \eqn{X_3 := \epsilon_3} with \eqn{\epsilon_3 \sim \mathrm{Unif}[5, 10]}}
\item{Z}{Structural equation: \eqn{Z := |\epsilon_4|} with \eqn{\epsilon_4 \sim N(10, 1)}}
\item{Y}{Structural equation: \eqn{Y := X_1^2 + X_2 - X_3 - Z + \epsilon_5} with \eqn{\epsilon_5 \sim N(10, 1)}}
}
}
\usage{
num_data
}
\description{
Simulated Numerical Data
}
\details{
The R code used to generate this dataset is as follows:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{set.seed(1405)
n <- 1000
Z <- abs(rnorm(n, mean = 10))
X1 <- sqrt(Z) + runif(n, min = 0, max = 2)
X3 <- runif(n, min = 5, max = 10)
X2 <- 2 * X3 - rnorm(n, mean = 5)
Y  <- X1^2 + X2 - X3 - Z + rnorm(n, mean = 10)
num_data <- data.frame(X1, X2, X3, Z, Y)
}\if{html}{\out{</div>}}
}
\examples{
data(num_data)
head(num_data)
}
\concept{dataset}
\keyword{datasets}
