% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-manipulation.R
\name{+.Knowledge}
\alias{+.Knowledge}
\title{Merge Knowledge Objects}
\usage{
\method{+}{Knowledge}(kn1, kn2)
}
\arguments{
\item{kn1}{A \code{Knowledge} object.}

\item{kn2}{Another \code{Knowledge} object.}
}
\description{
Merge Knowledge Objects
}
\examples{
# Create two Knowledge objects
kn1 <- knowledge(
  tier(
    1 ~ V1,
    2 ~ V2
  ),
  V1 \%-->\% V2
)

kn2 <- knowledge(
  tier(3 ~ V3),
  V2 \%!-->\% V3
)

kn_merged <- kn1 + kn2

# Error paths
# Merging with conflicting tier information

kn1 <- knowledge(
  tier(
    1 ~ V1,
    2 ~ V2
  )
)

kn2 <- knowledge(
  tier(3 ~ V2)
)

try(kn1 + kn2)

kn2 <- knowledge(
  tier(1 ~ V1 + V2)
)

try(kn1 + kn2)

# Requried / forbidden violations

kn1 <- knowledge(
  V1 \%!-->\% V2
)

kn2 <- knowledge(
  V1 \%-->\% V2
)

try(kn1 + kn2)
}
\seealso{
Other knowledge functions: 
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
