% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfci.R
\name{tfci}
\alias{tfci}
\title{TFCI Algorithm for Causal Discovery}
\usage{
tfci(engine = c("causalDisco"), test, alpha = 0.05, ...)
}
\arguments{
\item{engine}{Character; which engine to use. Must be one of:
\describe{
\item{\code{"causalDisco"}}{causalDisco library.}
}}

\item{test}{Character; name of the conditional‐independence test.}

\item{alpha}{Numeric; significance level for the CI tests.}

\item{...}{Additional arguments passed to the chosen engine
(e.g. test or algorithm parameters).}
}
\description{
Run the temporal FCI algorithm for causal discovery using causalDisco.
}
\details{
For specific details on the supported tests, see \link{CausalDiscoSearch}. For additional parameters passed
via \code{...}, see \code{\link[=tfci_run]{tfci_run()}}.
}
\section{Recommendation}{

While it is possible to call the function returned directly with a data frame,
we recommend using \code{\link[=disco]{disco()}}. This provides a consistent interface and handles knowledge
integration.
}

\section{Value}{

A function that takes a single argument \code{data} (a data frame). When called,
this function returns a list containing:
\itemize{
\item \code{knowledge} A \code{Knowledge} object with the background knowledge
used in the causal discovery algorithm. See \code{\link[=knowledge]{knowledge()}} for how to construct it.
\item \code{caugi} A \code{\link[caugi:caugi]{caugi::caugi}} object representing the learned causal graph.
This graph is a PAG (Partial Ancestral Graph), but since PAGs are not yet
natively supported in \code{caugi}, it is currently stored with class \code{UNKNOWN}.
}
}

\examples{
data(tpc_example)

kn <- knowledge(
  tpc_example,
  tier(
    child ~ tidyselect::starts_with("child"),
    youth ~ tidyselect::starts_with("youth"),
    oldage ~ tidyselect::starts_with("oldage")
  )
)

# Recommended path using disco()
my_tfci <- tfci(engine = "causalDisco", test = "fisher_z", alpha = 0.05)

disco(tpc_example, my_tfci, knowledge = kn)

# or using my_tfci directly
my_tfci <- my_tfci |> set_knowledge(kn)
my_tfci(tpc_example)

# Also possible: using tfci_run()
tfci_run(tpc_example, test = cor_test, knowledge = kn)
}
\seealso{
Other causal discovery algorithms: 
\code{\link{boss}()},
\code{\link{boss_fci}()},
\code{\link{fci}()},
\code{\link{ges}()},
\code{\link{gfci}()},
\code{\link{grasp}()},
\code{\link{grasp_fci}()},
\code{\link{gs}()},
\code{\link{iamb-family}},
\code{\link{pc}()},
\code{\link{sp_fci}()},
\code{\link{tges}()},
\code{\link{tpc}()}
}
\concept{causal discovery algorithms}
\concept{cd_algorithms}
