% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfci-run.R
\name{tfci_run}
\alias{tfci_run}
\title{Run the TFCI Algorithm for Causal Discovery}
\usage{
tfci_run(
  data = NULL,
  knowledge = NULL,
  alpha = 0.05,
  test = reg_test,
  suff_stat = NULL,
  method = "stable.fast",
  na_method = "none",
  orientation_method = "conservative",
  directed_as_undirected = FALSE,
  varnames = NULL,
  num_cores = 1,
  ...
)
}
\arguments{
\item{data}{A data frame with the observed variables.}

\item{knowledge}{A \emph{knowledge} object describing tiers/periods and optional
forbidden/required edges. This replaces the legacy \code{order} interface and
is the preferred way to supply temporal background knowledge.}

\item{alpha}{The alpha level used as the per-test significance
threshold for conditional independence testing.}

\item{test}{A conditional independence test. The default \code{reg_test}
uses a regression-based information-loss test. Another available option is
\code{cor_test} which tests for vanishing partial correlations. User-supplied
functions may also be used; see details for the required interface.}

\item{suff_stat}{A sufficient statistic. If supplied, it is passed directly
to the test and no statistics are computed from \code{data}. Its structure
depends on the chosen \code{test}.}

\item{method}{Skeleton construction method, one of \code{"stable"},
\code{"original"}, or \code{"stable.fast"} (default). See
\code{\link[pcalg:skeleton]{pcalg::skeleton()}} for details.}

\item{na_method}{Handling of missing values, one of \code{"none"} (default;
error on any \code{NA}), \code{"cc"} (complete-case analysis), or
\code{"twd"} (test-wise deletion).}

\item{orientation_method}{Method for handling conflicting separating sets when orienting
edges; must be one of \code{"standard"}, \code{"conservative"} (the default) or
\code{"maj.rule"}. See \code{\link[pcalg:pc]{pcalg::pc()}} for further details.}

\item{directed_as_undirected}{Logical; if \code{TRUE}, treat any directed
edges in \code{knowledge} as undirected during skeleton learning. This
is due to the fact that \pkg{pcalg} does not allow directed edges in
\code{fixedEdges} or \code{fixedGaps}. Default is \code{FALSE}.}

\item{varnames}{Character vector of variable names. Only needed when
\code{data} is not supplied and all information is passed via
\code{suff_stat}.}

\item{num_cores}{Integer number of CPU cores to use for parallel skeleton learning.}

\item{...}{Additional arguments passed to
\code{\link[pcalg:skeleton]{pcalg::skeleton()}} during skeleton construction.}
}
\value{
A \code{Disco} object (a list with a \code{caugi} and a \code{knowledge}object).
}
\description{
Use a modification of the FCI algorithm that makes use of background knowledge
in the format of a partial ordering. This may, for instance, come about when
variables can be assigned to distinct tiers or periods (i.e., a temporal ordering).
}
\details{
The temporal/tiered background information enters several places in the TFCI
algorithm: (1) In the skeleton construction phase, when looking for separating
sets \eqn{Z} between two variables \eqn{X} and \eqn{Y}, \eqn{Z} is not allowed to
contain variables that are strictly after both \eqn{X} and \eqn{Y} in the temporal
order (as specified by the \code{knowledge} tiers). (2) This also applies to the
subsequent phase where the algorithm searches for possible D-SEP sets. (3) Prior
to other orientation steps, any cross-tier edges get an arrowhead placed at their
latest node.

After this, the usual FCI orientation rules are applied; see \code{\link[pcalg:udag2pag]{pcalg::udag2pag()}}
for details.
}
\examples{
data(tpc_example)

kn <- knowledge(
  tpc_example,
  tier(
    child ~ tidyselect::starts_with("child"),
    youth ~ tidyselect::starts_with("youth"),
    oldage ~ tidyselect::starts_with("oldage")
  )
)

# Recommended path using disco()
my_tfci <- tfci(engine = "causalDisco", test = "fisher_z", alpha = 0.05)

disco(tpc_example, my_tfci, knowledge = kn)

# or using my_tfci directly
my_tfci <- my_tfci |> set_knowledge(kn)
my_tfci(tpc_example)

# Also possible: using tfci_run()
tfci_run(tpc_example, test = cor_test, knowledge = kn)
}
