% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tges-run.R
\name{tges_run}
\alias{tges_run}
\title{Run the TGES Algorithm for Causal Discovery}
\usage{
tges_run(score, verbose = FALSE)
}
\arguments{
\item{score}{tiered scoring object to be used.
At the moment only scores supported are
\itemize{
\item \link{TemporalBIC} and
\item \link{TemporalBDeu}.
}}

\item{verbose}{indicates whether debug output should be printed.}
}
\value{
A \code{Disco} object (a list with a \code{caugi} and a \code{knowledge} object).
}
\description{
Perform causal discovery using the temporal greedy equivalence search algorithm.
}
\examples{
# Recommended route using disco:
kn <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    old ~ starts_with("old")
  )
)

my_tges <- tges(engine = "causalDisco", score = "tbic")

disco(tpc_example, my_tges, knowledge = kn)

# another way to run it

my_tges <- my_tges |>
  set_knowledge(kn)
my_tges(tpc_example)


# or you can run directly with tges_run()

data(tpc_example)

score_bic <- new(
  "TemporalBIC",
  data = tpc_example,
  nodes = colnames(tpc_example),
  knowledge = kn
)

res_bic <- tges_run(score_bic)
res_bic
}
\author{
Tobias Ellegaard Larsen
}
