% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_esi.R
\name{get_esi}
\alias{get_esi}
\alias{get_esi.default}
\alias{get_esi.sf}
\alias{get_esi.geojson}
\title{Get evaporative stress index (ESI) data}
\usage{
get_esi(object, dates, operation = 5, period = 1, ...)

\method{get_esi}{default}(object, dates, operation = 5, period = 1, ...)

\method{get_esi}{sf}(object, dates, operation = 5, period = 1, as.sf = FALSE, ...)

\method{get_esi}{geojson}(object, dates, operation = 5, period = 1, as.geojson = FALSE, ...)
}
\arguments{
\item{object}{input, an object of class \code{\link[base]{data.frame}} (or
any other object that can be coerced to \code{data.frame}),
\code{\link[terra]{SpatVector}}, \code{\link[terra]{SpatRaster}},
\code{\link[sf]{sf}} or \code{geojson}}

\item{dates}{a character of start and end dates in that order in the format
"YYYY-MM-DD"}

\item{operation}{optional, an integer that represents which type of
statistical operation to perform on the dataset}

\item{period}{an integer value for the period of ESI data, four weeks
period = 1, twelve weeks = 2}

\item{...}{additional arguments passed to \code{\link[terra]{terra}}
or \code{\link[sf]{sf}} methods
See details}

\item{as.sf}{logical, returns an object of class \code{\link[sf]{sf}}}

\item{as.geojson}{logical, returns an object of class \code{geojson}}
}
\value{
A data frame of \acronym{ESI} data:
\item{id}{the index for the rows in \code{object}}
\item{dates}{the dates from which ESI was requested}
\item{lon}{the longitude as provided in \code{object}}
\item{lat}{the latitude as provided in \code{object}}
\item{esi}{the ESI value}
}
\description{
Get evaporative stress index (\acronym{ESI}) from \acronym{SERVIR} Global via
ClimateSERV \acronym{API} Client. \acronym{ESI} is available every four
(or twelve) weeks from 2001 to present.
The dataset may contain cloudy data which is returned as \code{NA}s.
ClimateSERV works with 'geojson' of type 'Polygon'. The input \code{object}
is then transformed into polygons with a small buffer area around the point.
}
\details{
\bold{operation}: supported operations are:
 \tabular{rll}{
 \bold{operation}      \tab    \tab \bold{value}\cr
 max                   \tab =  \tab 0\cr
 min                   \tab =  \tab 1\cr
 median                \tab =  \tab 2\cr
 sum                   \tab =  \tab 4\cr
 average               \tab =  \tab 5 (\emph{default value})\cr
 }

\bold{dist}: numeric, buffer distance for each \code{object} coordinate

\bold{nQuadSegs}: integer, number of segments per buffer quadrant
}
\note{
\code{get_esi()} may return some warning messages given by
\code{\link[sf]{sf}}, please check the \CRANpkg{sf} documentation for
possible issues.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

lonlat = data.frame(lon = c(-55.0281,-54.9857),
                     lat = c(-2.8094, -2.8756))

dates = c("2017-12-15","2018-06-20")

# by default the function sets a very small buffer around the points which
# can return NAs due to cloudiness in ESI data

dt = get_esi(lonlat, dates = dates)

# the argument dist passed through sf increase the buffer area

dt = get_esi(lonlat, dates = dates, dist = 0.1)
\dontshow{\}) # examplesIf}
}
