% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stations_ogimet.R
\name{stations_ogimet}
\alias{stations_ogimet}
\title{Scrapping a list of meteorological (Synop) stations for a defined country from the Ogimet webpage}
\usage{
stations_ogimet(
  country = "United Kingdom",
  date = Sys.Date(),
  add_map = FALSE,
  allow_failure = TRUE
)
}
\arguments{
\item{country}{country name; Every word must be written with capital letters (e.g. "United Kingdom")}

\item{date}{a day when measurements were done in all available locations}

\item{add_map}{logical - whether to draw a map based on downloaded dataset (requires \code{maps} package)}

\item{allow_failure}{logical - whether to proceed or stop on failure. By default set to TRUE (i.e. don't stop on error). For debugging purposes change to FALSE}
}
\value{
A data.frame with columns describing the synoptic stations in selected countries where each row represent a statation.
If \code{add_map = TRUE} additional map of downloaded data is visualized.
}
\description{
Returns a list of meteorological stations with their coordinates from the Ogimet webpage. The returned list is valid only for a given day
}
\examples{
\donttest{
  stations_ogimet(country = "Australia", add_map = TRUE)
}

}
