% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdisc_metadata.R
\name{extract_cdisc_version}
\alias{extract_cdisc_version}
\title{Extract CDISC Version from TS Domain}
\usage{
extract_cdisc_version(ts_data)
}
\arguments{
\item{ts_data}{A data frame representing a TS (Trial Summary) domain.
Must contain at minimum TSPARMCD and TSVAL columns.}
}
\value{
A list containing:
\item{sdtm_ig_version}{Character: SDTM IG version (e.g., "3.4"), or NA}
\item{adam_ig_version}{Character: ADaM IG version (e.g., "1.3"), or NA}
\item{study_id}{Character: STUDYID from TS if available, or NA}
\item{protocol_title}{Character: Protocol title if available, or NA}
\item{version_note}{Character: Formatted note string for reports}
}
\description{
Reads a Trial Summary (TS) dataset and extracts the CDISC standard version
information. Looks for SDTM IG version (TSPARMCD = "SDTIGVER" or "CDISCVER")
and ADaM IG version (TSPARMCD = "ADAMIGVR") parameters.
}
\keyword{internal}
