\name{akin_aki_staging}
\alias{akin_aki_staging}
\title{
AKIN Classification for Acute Kidney Injury (AKI)
}
\description{
Classifies the severity of Acute Kidney Injury (AKI) based on the Acute Kidney Injury Network (AKIN) criteria. The staging is determined by the worst of two criteria: serum creatinine changes (relative to baseline) or urine output duration.
}
\usage{
akin_aki_staging(baseline_creatinine, max_creatinine,
                 urine_output_stage = 0, rrt_initiated = 0)
}
\arguments{
  \item{baseline_creatinine}{
Numeric. Baseline serum creatinine in mg/dL.
}
  \item{max_creatinine}{
Numeric. Maximum serum creatinine reached within 48 hours.
}
  \item{urine_output_stage}{
Numeric (0, 1, 2, or 3). The stage corresponding to the patient's urine output criteria.
0: Normal (> 0.5 ml/kg/hr).
1: < 0.5 ml/kg/hr for > 6 hours.
2: < 0.5 ml/kg/hr for > 12 hours.
3: < 0.3 ml/kg/hr for 24 hours OR Anuria for 12 hours.
}
  \item{rrt_initiated}{
Numeric (0 or 1). Was Renal Replacement Therapy (RRT) initiated? (1 = Yes, automatically Stage 3).
}
}
\value{
A list containing:
\item{AKIN_Stage}{The final classification (No AKI, Stage 1, Stage 2, or Stage 3).}
\item{Numeric_Stage}{Integer representation of the stage (0-3).}
\item{Criteria_Met}{Breakdown of stages derived from Creatinine vs. Urine Output components.}
}
\references{
Mehta RL, Kellum JA, Shah SV, et al. Acute Kidney Injury Network: report of an initiative to improve outcomes in acute kidney injury. Crit Care. 2007;11(2):R31. doi:10.1186/cc5713
}
\examples{

# Example 1: Stage 1 (Creatinine rise >= 0.3 mg/dL)
# Base 1.0, Max 1.3, Normal UO
akin_aki_staging(1.0, 1.3, 0, 0)

# Example 2: Stage 3 (Urine Output criteria)
# Base 1.0, Max 1.2 (No AKI by Cr), UO < 0.3 for 24h (Stage 3)
akin_aki_staging(1.0, 1.2, 3, 0)
}
