\name{calculate_mme}
\alias{calculate_mme}
\title{
Morphine Milligram Equivalents (MME) Calculator
}
\description{
Calculates the total daily Morphine Milligram Equivalents (MME) for a patient taking one or more opioid medications. The conversion factors are based on the 2016 CDC Guidelines for Prescribing Opioids for Chronic Pain. This metric helps clinicians assess the cumulative potency of an opioid regimen to mitigate overdose risk.
}
\usage{
calculate_mme(codeine_mg_day = 0, fentanyl_transdermal_mcg_hr = 0,
              hydrocodone_mg_day = 0, hydromorphone_mg_day = 0,
              methadone_mg_day = 0, morphine_mg_day = 0,
              oxycodone_mg_day = 0, oxymorphone_mg_day = 0,
              tapentadol_mg_day = 0, tramadol_mg_day = 0)
}
\arguments{
  \item{codeine_mg_day}{Numeric. Total daily dose of Codeine in mg.}
  \item{fentanyl_transdermal_mcg_hr}{Numeric. Dose of transdermal Fentanyl patch in mcg/hr.}
  \item{hydrocodone_mg_day}{Numeric. Total daily dose of Hydrocodone in mg.}
  \item{hydromorphone_mg_day}{Numeric. Total daily dose of Hydromorphone in mg.}
  \item{methadone_mg_day}{Numeric. Total daily dose of Methadone in mg. (Conversion factor varies by dose).}
  \item{morphine_mg_day}{Numeric. Total daily dose of Morphine in mg.}
  \item{oxycodone_mg_day}{Numeric. Total daily dose of Oxycodone in mg.}
  \item{oxymorphone_mg_day}{Numeric. Total daily dose of Oxymorphone in mg.}
  \item{tapentadol_mg_day}{Numeric. Total daily dose of Tapentadol in mg.}
  \item{tramadol_mg_day}{Numeric. Total daily dose of Tramadol in mg.}
}
\value{
A list containing:
\item{Total_MME_Day}{The calculated total Morphine Milligram Equivalents per day.}
\item{Risk_Interpretation}{Clinical guidance based on CDC risk thresholds (<50, 50-90, >=90 MME/day).}
}
\references{
Dowell D, Haegerich TM, Chou R. CDC Guideline for Prescribing Opioids for Chronic Pain — United States, 2016. MMWR Recomm Rep. 2016;65(1):1–49. doi:10.15585/mmwr.rr6501e1
}
\examples{

# Example 1: Mixed Regimen
# 30mg Oxycodone BID (60mg/day), 10mg Methadone daily
# Oxy: 60 * 1.5 = 90. Methadone: 10 * 4 = 40. Total = 130 MME.
calculate_mme(oxycodone_mg_day = 60, methadone_mg_day = 10)

# Example 2: Fentanyl Patch
# 25 mcg/hr patch
# MME = 25 * 2.4 = 60 MME.
calculate_mme(fentanyl_transdermal_mcg_hr = 25)
}
