\name{cam_icu_delirium_assessment}
\alias{cam_icu_delirium_assessment}
\title{
Confusion Assessment Method for the ICU (CAM-ICU)
}
\description{
Applies the CAM-ICU algorithm to diagnose delirium in critically ill, mechanically ventilated, or non-intubated patients. The diagnosis is positive if **Feature 1 AND Feature 2 AND (Feature 3 OR Feature 4)** are present. This tool is designed to be highly sensitive and specific when used by trained staff.
}
\usage{
cam_icu_delirium_assessment(acute_fluctuating, inattention, altered_loc,
                            disorganized_thinking)
}
\arguments{
  \item{acute_fluctuating}{
Numeric (0 or 1). Feature 1: Is there an acute change in mental status from baseline OR a fluctuation in the past 24 hours? (1 = Yes).
}
  \item{inattention}{
Numeric (0 or 1). Feature 2: Is the patient inattentive (e.g., failure on the Attention Screening Exam)? (1 = Yes).
}
  \item{altered_loc}{
Numeric (0 or 1). Feature 3: Is the patient's level of consciousness anything other than 0 (Alert and Calm) on the RASS? (1 = Yes).
}
  \item{disorganized_thinking}{
Numeric (0 or 1). Feature 4: Is there disorganized thinking (e.g., failure on the Commands/Questions set)? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Delirium Positive" or "Delirium Negative".}
\item{Required_Features_Met}{Boolean confirmation of the three core requirements of the diagnostic algorithm.}
}
\references{
Ely EW, Margolin B, Francis J, et al. Evaluation of delirium in critically ill patients: validation of the Confusion Assessment Method for the Intensive Care Unit (CAM-ICU). Crit Care Med. 2001;29(7):1370-1379. doi:10.1097/00003246-200107000-00012
}
\examples{

# Example 1: Delirium Positive
# Acute change (1), Inattention (1), LOC is normal (0), but Disorganized Thinking (1)
cam_icu_delirium_assessment(1, 1, 0, 1)

# Example 2: Delirium Negative (Fails F2)
# Acute change (1), Attention is normal (0), LOC altered (1), Disorganized (1)
cam_icu_delirium_assessment(1, 0, 1, 1)
}
