\name{curb65_pneumonia_severity}
\alias{curb65_pneumonia_severity}
\title{
CURB-65 Score for Pneumonia Severity
}
\description{
Calculates the CURB-65 score to estimate mortality risk in patients with community-acquired pneumonia. The score assesses Confusion, Urea (BUN), Respiratory rate, Blood pressure, and age >= 65.
}
\usage{
curb65_pneumonia_severity(confusion, bun, respiratory_rate, systolic_bp,
                          diastolic_bp, age, bun_units = "mg/dL")
}
\arguments{
  \item{confusion}{
Numeric (0 or 1). Presence of confusion (1 = Yes).
}
  \item{bun}{
Numeric. Blood Urea Nitrogen level. (> 19 mg/dL or > 7 mmol/L adds 1 point).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (>= 30 adds 1 point).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure. (< 90 mmHg contributes to BP criterion).
}
  \item{diastolic_bp}{
Numeric. Diastolic blood pressure. (<= 60 mmHg contributes to BP criterion).
Note: The BP point is added if SBP < 90 OR DBP <= 60.
}
  \item{age}{
Numeric. Patient age in years. (>= 65 adds 1 point).
}
  \item{bun_units}{
String. Units for BUN. "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{CURB65_Score}{The calculated score (Range 0-5).}
\item{Risk_Group}{Risk classification (Low, Moderate, High).}
\item{Est_30_Day_Mortality}{Estimated 30-day mortality percentage.}
\item{Recommendation}{Clinical guidance regarding disposition (Home vs. Hospital vs. ICU).}
}
\references{
Lim WS, van der Eerden MM, Laing R, et al. Defining community acquired pneumonia severity on presentation to hospital: an international derivation and validation study. Thorax. 2003;58(5):377-382. doi:10.1136/thorax.58.5.377
}
\examples{

# Example 1: High Risk
# 70yo (+1), Confused (+1), BUN 25 (+1), SBP 85 (+1), RR 20
# Score = 4
curb65_pneumonia_severity(1, 25, 20, 85, 60, 70)

# Example 2: Low Risk
# 50yo, Alert, BUN 10, RR 18, BP 120/80
# Score = 0
curb65_pneumonia_severity(0, 10, 18, 120, 80, 50)
}
