\name{pediatric_asthma_score}
\alias{pediatric_asthma_score}
\title{
Pediatric Asthma Score (PAS)
}
\description{
Calculates the Pediatric Asthma Score (PAS), an objective assessment tool used to determine the severity of an acute asthma exacerbation in children. The score evaluates five clinical components: respiratory rate, oxygen requirement, retractions, dyspnea (speech/activity), and auscultation findings. The total score ranges from 5 to 15.
}
\usage{
pediatric_asthma_score(age, respiratory_rate, oxygen_saturation,
                       on_supplemental_oxygen, retractions, dyspnea, auscultation)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. Used to stratify respiratory rate scoring.
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{oxygen_saturation}{
Numeric. Oxygen saturation (SpO2) percentage (0-100).
}
  \item{on_supplemental_oxygen}{
Numeric (0 or 1). Is the patient currently receiving supplemental oxygen? (1 = Yes). Note: Being on oxygen automatically assigns the maximum points (3) for the oxygen component.
}
  \item{retractions}{
String. Severity of retractions.
"none_intercostal": Normal to Intercostal retractions (1 pt).
"substernal_suprasternal": Substernal or Suprasternal retractions (2 pts).
"supraclavicular_flaring": Supraclavicular retractions, nasal flaring, or head bobbing (3 pts).
}
  \item{dyspnea}{
String. Speech or activity level limitations.
"sentences": Counts to 10, speaks in sentences, or normal activity (1 pt).
"phrases": Counts to 7, speaks in partial phrases, or decreased activity (2 pts).
"words": Counts to 3, speaks in single words, or minimal activity (3 pts).
}
  \item{auscultation}{
String. Breath sounds.
"end_expiratory": Normal breath sounds or end-expiratory wheeze only (1 pt).
"throughout": Expiratory wheezing > 50\% of exhalation +/- inspiratory wheezing (2 pts).
"diminished": Diminished or absent breath sounds (silent chest) (3 pts).
}
}
\value{
A list containing:
\item{PAS_Score}{The calculated total score (Range 5-15).}
\item{Severity}{Clinical severity classification (Mild 5-7, Moderate 8-11, Severe 12-15).}
\item{Subscores}{Breakdown of points assigned for each of the five components.}
}
\references{
Schuh S, et al. Efficacy of frequent nebulized ipratropium bromide added to frequent high-dose albuterol therapy in severe childhood asthma. J Pediatr. 1995;126(4):639-645.
}
\examples{

# Example 1: Moderate Exacerbation
# 6yo, RR 30 (2 pts), SpO2 92% (2 pts), Substernal retractions (2 pts),
# Phrases (2 pts), Throughout wheeze (2 pts)
# Score = 10
pediatric_asthma_score(6, 30, 92, 0, "substernal_suprasternal", "phrases", "throughout")

# Example 2: Mild Exacerbation
# 10yo, RR 20 (1 pt), SpO2 98% (1 pt), No retractions (1 pt),
# Sentences (1 pt), End-exp wheeze (1 pt)
# Score = 5
pediatric_asthma_score(10, 20, 98, 0, "none_intercostal", "sentences", "end_expiratory")
}
