\name{sirs_sepsis_criteria}
\alias{sirs_sepsis_criteria}
\title{
SIRS, Sepsis, and Septic Shock Criteria
}
\description{
Evaluates patients for Systemic Inflammatory Response Syndrome (SIRS), Sepsis, Severe Sepsis, and Septic Shock based on the 1992/2001 Consensus Conference definitions. Diagnosis is hierarchical based on the number of SIRS criteria met, the presence of infection, organ dysfunction, and refractory hypotension.
}
\usage{
sirs_sepsis_criteria(temperature_c, heart_rate, respiratory_rate, paco2_mmhg,
                     wbc_count, bands_percent, infection_suspected,
                     organ_dysfunction_hypotension, fluids_refractory_hypotension)
}
\arguments{
  \item{temperature_c}{
Numeric. Core temperature in degrees Celsius. (Abnormal: >38 or <36).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (Abnormal: >90).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (Abnormal: >20). Optional if PaCO2 is provided.
}
  \item{paco2_mmhg}{
Numeric. Partial pressure of carbon dioxide in arterial blood. (Abnormal: <32 mmHg). Optional if RR is provided.
}
  \item{wbc_count}{
Numeric. White Blood Cell count in x10^3/mm^3. (Abnormal: >12 or <4).
}
  \item{bands_percent}{
Numeric. Percentage of immature neutrophils (bands). (Abnormal: >10\%).
}
  \item{infection_suspected}{
Numeric (0 or 1). Is there a suspected or confirmed source of infection? (1 = Yes).
}
  \item{organ_dysfunction_hypotension}{
Numeric (0 or 1). Is there evidence of end-organ dysfunction (e.g., creatinine >2.0, platelets <100k, bilirubin >2, INR >1.5) or hypotension (SBP < 90 mmHg or Lactate > 4 mmol/L)? (1 = Yes).
}
  \item{fluids_refractory_hypotension}{
Numeric (0 or 1). Is there hypotension persistent despite adequate fluid resuscitation? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{The derived diagnosis (No SIRS, SIRS, Sepsis, Severe Sepsis, or Septic Shock).}
\item{SIRS_Criteria_Met}{The number of SIRS criteria satisfied (0-4).}
}
\references{
Bone RC, Balk RA, Cerra FB, et al. Definitions for sepsis and organ failure and guidelines for the use of innovative therapies in sepsis. The ACCP/SCCM Consensus Conference Committee. American College of Chest Physicians/Society of Critical Care Medicine. Chest. 1992;101(6):1644-1655. doi:10.1378/chest.101.6.1644
}
\examples{
# Example 1: Sepsis (2 SIRS + Infection)
sirs_sepsis_criteria(39.0, 100, 22, NA, 10.0, 5, 1, 0, 0)

# Example 2: Septic Shock (Sepsis + Refractory Hypotension)
sirs_sepsis_criteria(35.0, 110, 24, NA, 15.0, 0, 1, 1, 1)
}
