% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{clm_prior}
\alias{clm_prior}
\title{Prior Specification for clmstan}
\usage{
clm_prior(
  beta_sd = NULL,
  c_sd = NULL,
  c1_mu = NULL,
  c1_sd = NULL,
  d_alpha = NULL,
  d_beta = NULL,
  cpos_sd = NULL,
  df_alpha = NULL,
  df_beta = NULL,
  lambda_ao_alpha = NULL,
  lambda_ao_beta = NULL,
  lambda_lg_mu = NULL,
  lambda_lg_sd = NULL,
  xi_mu = NULL,
  xi_sd = NULL,
  r_alpha = NULL,
  r_beta = NULL,
  theta1_alpha = NULL,
  theta1_beta = NULL,
  theta2_alpha = NULL,
  theta2_beta = NULL
)
}
\arguments{
\item{beta_sd}{SD for normal prior on regression coefficients.
Default: 2.5 (weakly informative)}

\item{c_sd}{SD for normal prior on cutpoints (flexible threshold).
Default: 10}

\item{c1_mu}{Mean for normal prior on first cutpoint (equidistant threshold).
Default: 0}

\item{c1_sd}{SD for normal prior on first cutpoint (equidistant threshold).
Default: 10}

\item{d_alpha}{Gamma shape for interval d (equidistant threshold).
Default: 2}

\item{d_beta}{Gamma rate for interval d (equidistant threshold).
Default: 0.5}

\item{cpos_sd}{SD for half-normal prior on positive cutpoints (symmetric threshold).
Default: 5}

\item{df_alpha}{Gamma shape for tlink df. Default: 2}

\item{df_beta}{Gamma rate for tlink df. Default: 0.1}

\item{lambda_ao_alpha}{Gamma shape for aranda_ordaz lambda. Default: 0.5}

\item{lambda_ao_beta}{Gamma rate for aranda_ordaz lambda. Default: 0.5}

\item{lambda_lg_mu}{Normal mean for log_gamma lambda. Default: 0}

\item{lambda_lg_sd}{Normal SD for log_gamma lambda. Default: 1}

\item{xi_mu}{Normal mean for GEV xi. Default: 0}

\item{xi_sd}{Normal SD for GEV xi. Default: 2}

\item{r_alpha}{Gamma shape for SP r. Default: 0.5}

\item{r_beta}{Gamma rate for SP r. Default: 0.5}

\item{theta1_alpha}{Gamma shape for AEP theta1. Default: 2}

\item{theta1_beta}{Gamma rate for AEP theta1. Default: 1}

\item{theta2_alpha}{Gamma shape for AEP theta2. Default: 2}

\item{theta2_beta}{Gamma rate for AEP theta2. Default: 1}
}
\value{
An object of class \code{"clm_prior"} containing prior specifications.
}
\description{
Create prior specifications for cumulative link models in clmstan.

\strong{Default priors:}
\itemize{
\item Regression coefficients (beta): \code{normal(0, 2.5)}
\item Cutpoints (c): \code{normal(0, 10)} for flexible, \code{normal(0, 5)} for symmetric
\item Interval (d): \code{gamma(2, 0.5)} for equidistant threshold
}

\strong{Link parameter priors (when estimated):}\tabular{lll}{
   Link \tab Parameter \tab Default Prior \cr
   tlink \tab df \tab gamma(2, 0.1) \cr
   aranda_ordaz \tab lambda \tab gamma(0.5, 0.5) \cr
   gev \tab xi \tab normal(0, 2) \cr
   sp \tab r \tab gamma(0.5, 0.5) \cr
   log_gamma \tab lambda \tab normal(0, 1) \cr
   aep \tab theta1, theta2 \tab gamma(2, 1) \cr
}
}
\examples{
# Create a prior object (does not require Stan)
my_prior <- clm_prior(beta_sd = 2, c_sd = 5)
print(my_prior)

\dontrun{
# Examples below require CmdStan and compiled Stan models
data(wine, package = "ordinal")

# Default priors (no customization needed)
fit <- clm_stan(rating ~ temp, data = wine,
                chains = 2, iter = 500, warmup = 250, refresh = 0)

# Custom prior for regression coefficients
fit2 <- clm_stan(rating ~ temp, data = wine,
                 prior = clm_prior(beta_sd = 1),
                 chains = 2, iter = 500, warmup = 250, refresh = 0)
}
}
