% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCitations.R
\name{getCitations}
\alias{getCitations}
\title{Identify contributing studies}
\usage{
getCitations(tree, version = "1.5", data_path = FALSE)
}
\arguments{
\item{tree}{A phylogeny obtained from extractTree (see details).}

\item{version}{The version of the tree used in extract tree. Default to the most recent
version of the tree. and can be passed as a character string or as numeric. If an alternate
version was used to create the tree this function may fail or give incomplete or incorrect
citation information.}

\item{data_path}{Default to FALSE. If you are gathering citations for an
older version of the tree than the current one packed in the data object, you will have
already downloaded the data repo in order to generate that tree.
The data is available at https://github.com/McTavishLab/AvesData.
If you have manually downloaded the repo, use data_path= the path to the download location.
Alternately, you can download the full data repo using \code{\link[=get_avesdata_repo]{get_avesdata_repo()}}.
This approach will download the data and set an environmental variable AVESDATA_PATH.
When AVESDATA_PATH is set, the data_path argument will default to this value.
To manually set AVESDATA_PATH to the location of your downloaded AvesData repo
use \code{\link[=set_avesdata_repo_path]{set_avesdata_repo_path()}}}
}
\value{
A dataframe of the percent of internal nodes supported by a given study, as well
as the DOI of that study. The proportion of taxa in the tree supported by taxonomic
addition only is also included in the dataframe.
}
\description{
Quantify the contribution of studies informing an extracted tree,
and obtain DOI and citation information for those studies.
}
\details{
The function will determine
what proportion of nodes in your phylogeny are supported by each study that goes into
creating the final clootl tree. We use 'supported by' in the sense described in
Redelings and Holder, PeerJ (2017) https://peerj.com/articles/3058/, and as shown in the
tree.opentreeoflife.org tree viewer. We normalize these values to
a percentage of internal nodes in the target tree supported by each study.
In any resulting publication, please cite both the
synthetic tree (McTavish et al. 2025), clootl (Miller et al. 2025) and
"all" the trees/DOIs that contributed to
your phylogeny. That said, we are well aware of citation and word count
limits that plague modern publishing, and for this reason we quantify the
contribution of each study; depending on your phylogeny,
it is very possible that one or two studies contributed the majority of information.
This function relies on the phylogenetic synthesis information directly,
and is agnostic to taxonomy version.
}
\examples{
\donttest{#pull the taxonomy file out
data(clootl_data)
tax <- clootl_data$taxonomy.files$Year2021
ls(tax)
#subset to species only
# TODO: this step seems no longer necessary, is it??
# tax <- tax[tax$CATEGORY=="species",]

#simulate extracting a tree for a particular family
temp <- tax[tax$FAMILY=="Rhinocryptidae (Tapaculos)",]
spp <- temp$SCI_NAME

#get your tree
prunedTree <- extractTree(species=spp, label_type="scientific",
   taxonomy_year=2021, version="1.5")

#get your citation DF
 yourCitations <- getCitations(tree=prunedTree)}
}
\author{
Eliot Miller, Emily Jane McTavish
}
