% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{data the data frame}
\alias{data the data frame}
\alias{replace_values}
\title{Replace values across a data frame}
\usage{
replace_values(data, to_replace, replace_with)
}
\arguments{
\item{data}{The input data frame to be modified.}

\item{to_replace}{A vector of values to be replaced within the data frame. This must be the same length as \code{replace_with}.}

\item{replace_with}{A vector of corresponding replacement values. This must be the same length as \code{to_replace}.}
}
\value{
Modified data frame with specified values replaced.
}
\description{
Replace all occurrences of given values in all columns of a data frame.

The \code{data} data frame contains a collection of records, with attributes organized in columns. It may include various types of values, such as numerical, categorical, or textual data.
}
\examples{
\donttest{
data <- data.frame(
  q1 = c("neg2", "neg1", "0"),
  q2 = c("1", "neg2", "neg1")
)

replace_values(
  data,
  to_replace = c("neg2", "neg1"),
  replace_with = c("-2", "-1")
)
}
}
