% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_grid.R
\name{grid_search}
\alias{grid_search}
\title{Grid Search Solver}
\usage{
grid_search(lower, upper, n = 10L)
}
\arguments{
\item{lower}{Lower bounds for the grid}

\item{upper}{Upper bounds for the grid}

\item{n}{Number of points per dimension (scalar or vector)}
}
\value{
A solver function with signature (problem, theta0, trace) -> mle_result
}
\description{
Creates a solver that evaluates the log-likelihood on a grid of points
and returns the best. Useful for finding good starting points or for
low-dimensional problems.
}
\details{
Grid search is deterministic and exhaustive within its bounds. It's most
useful for 1-3 dimensional problems or as the first stage of a multi-stage
strategy (e.g., grid_search %>>% gradient_ascent).

The theta0 argument is ignored; the grid is determined by lower/upper/n.
Points outside the problem's constraint support are skipped.
}
\examples{
\donttest{
set.seed(42)
x <- rnorm(50, 5, 2)
problem <- mle_problem(
  loglike = function(theta) sum(dnorm(x, theta[1], theta[2], log = TRUE)),
  constraint = mle_constraint(support = function(theta) theta[2] > 0,
                              project = function(theta) c(theta[1], max(theta[2], 1e-8)))
)
# Simple grid search
solver <- grid_search(lower = c(-10, 0.1), upper = c(10, 5), n = 20)
result <- solver(problem, c(0, 1))

# Coarse-to-fine: grid then gradient
strategy <- grid_search(c(-10, 0.1), c(10, 5), n = 5) \%>>\% gradient_ascent()
}

}
