% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_subgroup_binary.R
\name{forest_bin_subgroup}
\alias{forest_bin_subgroup}
\title{Subgroup Forest Plot for Binary Outcome Meta-analysis}
\usage{
forest_bin_subgroup(
  dat,
  subgroup = NULL,
  measure = "RR",
  method = "REML",
  nc_col = "n_c",
  ne_col = "n_t",
  event_c_col = "events_c",
  event_t_col = "events_t",
  xlab = "Risk Ratio (RR)",
  title = "Subgroup Forest Plot",
  diamond.col = "red",
  overall.col = "darkgreen",
  study.col = "blue",
  CI.col = "blue",
  Pred.Inter.col = "black",
  square.size = 8,
  Pred.Int.size = 2,
  xlim = c(-2, 3.5),
  tlim = c(0, 2.3),
  text_size = 3.5,
  xpos = list(EventsT = -1, EventsC = -0.4, Effect = 2.5, Weight = 3.2),
  study_x = -1.8,
  val_x = 2.6,
  contour_left_min = c(0, 0.5, 0.67, 0.83),
  contour_left_max = c(0.5, 0.67, 0.83, 1),
  contour_right_min = c(1, 1.2, 1.5, 2),
  contour_right_max = c(1.2, 1.5, 2, 2.5),
  pred = TRUE
)
}
\arguments{
\item{dat}{A data frame containing study-level data. Must include columns for treatment and control events and sample sizes, and optionally a \code{subgroup} column.}

\item{subgroup}{Column name in \code{dat} specifying subgroup membership (character or factor). Defaults to NULL (no subgroups).}

\item{measure}{Effect measure to use. Default is "RR" (risk ratio).}

\item{method}{Method for random-effects meta-analysis. Default is "REML".}

\item{nc_col}{Character. Column name for control group sample sizes.}

\item{ne_col}{Character. Column name for treatment group sample sizes.}

\item{event_c_col}{Character. Column name for number of events in control group.}

\item{event_t_col}{Character. Column name for number of events in treatment group.}

\item{xlab}{Label for the x-axis. Default is "Risk Ratio (RR)".}

\item{title}{Plot title. Default is "Subgroup Forest Plot".}

\item{diamond.col}{Color for subgroup pooled effect diamonds. Default is "red".}

\item{overall.col}{Color for overall pooled effect diamond. Default is "darkgreen".}

\item{study.col}{Color for individual study points. Default is "blue".}

\item{CI.col}{Color for study confidence interval bars. Default is "blue".}

\item{Pred.Inter.col}{Color for prediction interval bars. Default is "black".}

\item{square.size}{Maximum size of study points. Default is 8.}

\item{Pred.Int.size}{Thickness of prediction interval line. Default is 2.}

\item{xlim}{Numeric vector of length 2 giving x-axis limits. Default is c(-2, 3.5).}

\item{tlim}{Numeric vector of length 2 for truncating study CIs. Default is c(0, 2.3).}

\item{text_size}{Base text size for labels. Default is 3.5.}

\item{xpos}{List of x-axis positions for EventsT, EventsC, Effect, and Weight labels. Default is list(EventsT=-1, EventsC=-0.4, Effect=2.5, Weight=3.2).}

\item{study_x}{X position for study names. Default is -1.8.}

\item{val_x}{X position for pooled effect labels. Default is 2.6.}

\item{contour_left_min}{Numeric vector defining left contour minimum values. Default is c(0, 0.5, 0.67, 0.83).}

\item{contour_left_max}{Numeric vector defining left contour maximum values. Default is c(0.5, 0.67, 0.83, 1).}

\item{contour_right_min}{Numeric vector defining right contour minimum values. Default is c(1, 1.2, 1.5, 2).}

\item{contour_right_max}{Numeric vector defining right contour maximum values. Default is c(1.2, 1.5, 2, 2.5).}

\item{pred}{Logical indicating whether to show the prediction interval. Default is TRUE.}
}
\value{
A \code{ggplot} object representing the contour-enhanced subgroup forest plot.
}
\description{
Generates a contour-enhanced forest plot for binary outcome data, with optional subgroup analysis.
This function calculates risk ratios (or other measures) and displays study-specific effect sizes,
pooled subgroup effects, overall pooled effect, and heterogeneity statistics (I^2, tau^2).
}
\examples{
# Load example dataset
data <- bcg()

# Generate subgroup forest plot
forest_bin_subgroup(
  dat = bcg(),
  tlim = c(0, 2.3),
  contour_left_min  = c(0, 0.3, 0.5, 0.7),
  contour_left_max  = c(0.3, 0.5, 0.7, 1),
  contour_right_min = c(1, 1.2, 1.5, 1.8),
  contour_right_max = c(1.2, 1.5, 1.8, 2.4)
)
}
