% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_chrr_measures.R
\name{list_chrr_measures}
\alias{list_chrr_measures}
\title{List available CHR&R measures for a given release year}
\usage{
list_chrr_measures(release_year = NULL)
}
\arguments{
\item{release_year}{Numeric year corresponding to the year of
CHR&R's annual data release. Defaults to the most recent release
year if \code{NULL}.}
}
\value{
A tibble (class \code{tbl_df}) with one row per measure for the
specified release year and the following columns:
\describe{
\item{measure_id}{Numeric. Unique identifier for the measure.}
\item{measure_name}{Character. Name of the measure.}
\item{description}{Character. Brief description of the measure.}
}
}
\description{
Downloads metadata for a release year and returns measure identifiers,
names, and descriptions.
}
\examples{
\donttest{
measures <- list_chrr_measures(2023)
head(measures)
}
}
