% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{CohortSizeDLT-class}
\alias{CohortSizeDLT-class}
\alias{.CohortSizeDLT}
\alias{CohortSizeDLT}
\alias{.DefaultCohortSizeDLT}
\title{\code{CohortSizeDLT}}
\usage{
CohortSizeDLT(intervals, cohort_size)

.DefaultCohortSizeDLT()
}
\arguments{
\item{intervals}{(\code{numeric})\cr see slot definition.}

\item{cohort_size}{(\code{numeric})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{CohortSizeDLT}} is the class for cohort size based on number of DLTs.
}
\section{Slots}{

\describe{
\item{\code{intervals}}{(\code{integer})\cr a vector with the left bounds of the
relevant DLT intervals.}

\item{\code{cohort_size}}{(\code{integer})\cr a vector with the cohort sizes corresponding
to the elements of \code{intervals}.}
}}

\note{
Typically, end users will not use the \code{.DefaultCohortSizeDLT()} function.
}
\examples{
# Rule for having cohort of size 1 until no DLT is observed and having cohort
# of size 3 as soon as 1 DLT is observed.
my_size <- CohortSizeDLT(intervals = c(0, 1), cohort_size = c(1, 3))
}
