% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingMTDCV-class}
\alias{StoppingMTDCV-class}
\alias{.StoppingMTDCV}
\alias{StoppingMTDCV}
\alias{.DefaultStoppingMTDCV}
\title{\code{StoppingMTDCV}}
\usage{
StoppingMTDCV(target = 0.3, thresh_cv = 40, report_label = NA_character_)

.DefaultStoppingMTDCV()
}
\arguments{
\item{target}{(\code{proportion})\cr see slot definition.}

\item{thresh_cv}{(\code{number})\cr see slot definition.}

\item{report_label}{(\code{string} or \code{NA})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{StoppingMTDCV}} is a class for stopping rule based on precision of MTD
which is calculated as the coefficient of variation (CV) of the MTD.
Here, the MTD is defined as the dose that reaches a specific \code{target}
probability of the occurrence of a DLT.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{proportion})\cr toxicity target of MTD (except 0 or 1).}

\item{\code{thresh_cv}}{(\code{number})\cr threshold (percentage > 0) for CV to be
considered accurate enough to stop the trial. The stopping occurs when the
CV is less than or equal to \code{tresh_cv}.}
}}

\note{
Typically, end users will not use the \code{.DefaultStoppingMTDCV()} function.
}
\examples{
# Stopping the study if the MTD estimation is precise enough, i.e. if robust
# coefficient of variation of the MTD is below 40\%.
my_stopping <- StoppingMTDCV(target = 0.3, thresh_cv = 40)
}
