% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McmcOptions-methods.R
\name{saveSample}
\alias{saveSample}
\alias{saveSample,McmcOptions-method}
\alias{saveSample-McmcOptions}
\title{Determining if this Sample Should be Saved}
\usage{
saveSample(object, iteration, ...)

\S4method{saveSample}{McmcOptions}(object, iteration, ...)
}
\arguments{
\item{object}{(\code{McmcOptions})\cr object based on which the answer is
determined.}

\item{iteration}{(\code{count})\cr the current iteration index.}

\item{...}{not used.}
}
\value{
\code{TRUE} if this sample should be saved.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A method that determines if a sample from a given \code{iteration} should be
saved. The sample should be saved if and only if:
it is not in burn-in period and it matches the \code{step}.
}
\section{Functions}{
\itemize{
\item \code{saveSample(McmcOptions)}: determine if a sample should be saved.

}}
\examples{
# Set up the MCMC option in order to have a burn-in of 10000 iterations and
# then take every other iteration up to a collection of 10000 samples.
my_options <- McmcOptions(burnin = 10000, step = 2, samples = 10000)

size(my_options)
saveSample(my_options, iteration = 5)
}
