% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{predict_instance_for_token}
\alias{predict_instance_for_token}
\title{Internal: predict nuisance values for an instance and token}
\usage{
predict_instance_for_token(
  inst_key,
  token,
  data,
  methods,
  plan,
  fit_child_map,
  pred_child_map,
  K,
  fold_idx,
  model_cache,
  mode
)
}
\arguments{
\item{inst_key}{Instance key in \code{plan$instances}.}

\item{token}{An evaluation or training token.}

\item{data}{Training data (matrix or data frame).}

\item{methods}{Methods list.}

\item{plan}{Cross-fitting plan.}

\item{fit_child_map}{Child map for \code{fit()} dependencies.}

\item{pred_child_map}{Child map for \code{predict()} dependencies.}

\item{K}{Number of folds.}

\item{fold_idx}{List mapping folds to row indices.}

\item{model_cache}{Environment used to store fitted models.}

\item{mode}{Either \code{"estimate"} or \code{"predict"} (method
mode).}
}
\value{
In \code{mode = "predict"}, a prediction function of
\code{newdata}. In \code{mode = "estimate"}, a vector or matrix of
predictions on the relevant subset of \code{data}.
}
\description{
Recursively produces predictions for a given instance under a given
token. This ensures the corresponding model is fitted (via
\code{\link{ensure_model}}), gathers predictions from child nuisances
as additional inputs, and then calls the instance's \code{predict()}
function.
}
\details{
In \code{mode = "predict"}, this returns a \emph{layered} prediction
function on newdata, suitable for building cross-fitted predictors
for the target. In \code{mode = "estimate"}, it returns the
prediction values on the appropriate folds (eval or train).
}
\keyword{internal}
