% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_dataset_create.R
\name{cto_dataset_create}
\alias{cto_dataset_create}
\alias{cto_dataset_upload}
\title{Create or Upload to Server Datasets}
\usage{
cto_dataset_create(
  id,
  title = id,
  discriminator = NULL,
  unique_record_field = NULL,
  allow_offline_updates = NULL,
  id_format_options = list(prefix = NULL, allowCapitalLetters = NULL, suffix = NULL,
    numberOfDigits = NULL),
  cases_management_options = list(otherUserCode = NULL, showFinalizedSentWhenTree = NULL,
    enumeratorDatasetId = NULL, showColumnsWhenTable = NULL, displayMode = NULL,
    entryMode = NULL),
  location_context = list(parentGroupId = 1, siblingBelow = list(itemClass = NULL, id =
    NULL), siblingAbove = list(itemClass = NULL, id = NULL))
)

cto_dataset_upload(
  id,
  file,
  upload_mode = c("APPEND", "MERGE", "CLEAR"),
  joining_field = NULL
)
}
\arguments{
\item{id}{String. The unique identifier for the dataset (e.g., "household_data").}

\item{title}{String. The display title of the dataset. Defaults to \code{id}.}

\item{discriminator}{String. The type of dataset to create.}

\item{unique_record_field}{String. The name of the field that
uniquely identifies records. Required if \code{upload_mode} is "merge".}

\item{allow_offline_updates}{Logical. Whether the dataset allows
updates while offline.}

\item{id_format_options}{List. Options for formatting IDs within the dataset.}

\item{cases_management_options}{List. Specific configurations for case management}

\item{location_context}{List. Metadata regarding where the dataset resides.}

\item{file}{String. Path to the local CSV file to upload.}

\item{upload_mode}{String. How the data should be handled.}

\item{joining_field}{String. The column name used to match records
during a "merge". Often the same as \code{unique_record_field}.}
}
\value{
A list containing the API response (metadata for creation, or job summary for upload).
}
\description{
These functions manage the lifecycle of SurveyCTO server datasets: creating the
container definition and populating it with data.
\itemize{
\item \code{cto_dataset_create()}: Creates a new dataset with the specified configuration.
\item \code{cto_dataset_upload()}: Uploads records from a CSV file to the specified dataset. Supports:
\itemize{
\item APPEND: add new records
\item MERGE: update existing records based on unique field
\item CLEAR: replace all data
}
}
}
\examples{
\dontrun{
# 1. Create the container
cto_dataset_create(
id = "hh_data",
title = "Household Data",
unique_record_field = "hh_id"
)

# 2. Upload data to it
cto_dataset_upload(
file = "data.csv",
id = "hh_data",
upload_mode = "merge",
joining_field = "hh_id"
)
}
}
\seealso{
Other Dataset Management Functions: 
\code{\link{cto_dataset_delete}()},
\code{\link{cto_dataset_download}()},
\code{\link{cto_dataset_info}()},
\code{\link{cto_dataset_list}()}
}
\concept{Dataset Management Functions}
