% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{comp_funs<-}
\alias{comp_funs<-}
\alias{comp_funs<-.drift_dm}
\alias{comp_funs}
\alias{comp_funs.drift_dm}
\alias{comp_funs.fits_ids_dm}
\alias{comp_funs.fits_agg_dm}
\title{The Component Functions of A Model}
\usage{
comp_funs(object, ...) <- value

\method{comp_funs}{drift_dm}(object, ..., eval_model = FALSE) <- value

comp_funs(object, ...)

\method{comp_funs}{drift_dm}(object, ...)

\method{comp_funs}{fits_ids_dm}(object, ...)

\method{comp_funs}{fits_agg_dm}(object, ...)
}
\arguments{
\item{object}{an object of type \link{drift_dm}, \code{fits_ids_dm}, or
\code{fits_agg_dm} (see \code{\link[=estimate_dm]{estimate_dm()}}).}

\item{...}{additional arguments passed down to the specific method.}

\item{value}{a named list which provides the component functions to set
(see Details)}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not when updating the component funtions (see \link{re_evaluate_model}).
Default is \code{FALSE}.}
}
\value{
For \code{comp_funs()} the list of component functions.

For \verb{comp_funs<-()} the updated \link{drift_dm} object.
}
\description{
Functions to get or set the "component functions" of an object. The component
functions are a list of functions providing the drift rate, boundary,
starting point distribution, and non-decision time distribution They are at
the heart of the package and shape the model's behavior.
}
\details{
\code{comp_funs()} is a generic accessor function, and \verb{comp_funs<-()} is a
generic replacement function. The default methods get and set the "component
functions". The component functions are a list of functions, with the
following names (see also \code{vignette("customize_ddms", "dRiftDM")} for
examples):
\itemize{
\item \code{mu_fun} and \code{mu_int_fun}, provide the drift rate and its integral,
respectively, across the time space.
\item \code{x_fun} provides a distribution of the starting point across the evidence
space.
\item \code{b_fun} and \code{dt_b_fun} provide the values of the upper decision boundary
and its derivative, respectively, across the time space. It is assumed that
boundaries are symmetric.
\item \code{nt_fun} provides a distribution of the non-decision component across the
time space.
}

All of the listed functions are stored in the list \code{comp_funs} of the
respective model (see also \code{\link[=drift_dm]{drift_dm()}}).

Each component function must take the model's parameters (i.e., one row of
\code{prms_matrix}), the parameters for deriving the PDFs, the time or evidence
space, a condition, and a list of optional values as arguments.
These arguments are provided with values when \code{dRiftDM} internally calls them.

In order to work with \code{dRiftDM}, \code{mu_fun}, \code{mu_int_fun}, \code{b_fun},
\code{dt_b_fun}, and \code{nt_fun} must have the following declaration:
\verb{my_fun = function(prms_model, prms_solve, t_vec, one_cond, ddm_opts}). Here,
\code{prms_model} is one row of \code{prms_matrix}, \link{prms_solve} the
parameters relevant for deriving the PDFs, \code{t_vec} the time space, going from
0 to \code{t_max} with length \code{nt + 1} (see \link{drift_dm}), and
\code{one_cond} a single character string, indicating the current condition.
Finally \code{dmm_opts} may contain additional values.
Each function must return a numeric vector
of the same length as \code{t_vec}. For \code{mu_fun},
\code{mu_int_fun}, \code{b_fun}, \code{dt_b_fun} the returned values provide the
respective boundary/drift rate (and their derivative/integral) at every time
step \eqn{t}. For \code{nt_fun} the returned values provide the density of the
non-decision time across the time space (which get convoluted with the
pdfs when solving the model)

In order to work with \code{dRiftDM}, \code{x_fun} must have the following
declaration:
\verb{my_fun = function(prms_model, prms_solve, x_vec, one_cond, ddm_opts}).
Here, \code{x_vec} is the evidence space, going from -1 to 1 with length \code{nx + 1}
(see \link{drift_dm}). Each function must return a numeric vector
of the same length as \code{x_vec}, providing the density values of the
starting points across the evidence space.
\subsection{Drift rate and its integral:}{

The drift rate is the first derivative of the expected time-course
of the diffusion process. For instance, if we assume that the diffusion
process \eqn{X} is linear with a slope of \eqn{v}...
\deqn{E(X) = v \cdot t}
...then the drift rate at every time step \eqn{t} is the constant \eqn{v},
obtained by taking the derivative of the expected time-course with respect
to \eqn{t}:
\deqn{\mu(t) = v}
Conversely, the integral of the drift rate is identical to the expected
time-course:
\deqn{\mu_{int}(t) = v \cdot t}

For the drift rate \code{mu_fun}, the default function when calling \code{drift_dm()}
is a numeric vector containing the number \eqn{3}. Its integral counterpart
\code{mu_int_fun} will return a numeric vector containing the values \code{t_vec*3}.
}

\subsection{Starting Point Distribution:}{

The starting point of a diffusion model refers to the initial value taken
by the evidence accumulation process at time \eqn{t=0}. This is a PDF
over the evidence space.

The default function when calling \code{drift_dm()} will be a function
returning a dirac delta on zero, meaning that every potential diffusion
process starts at 0.
}

\subsection{Boundary:}{

The Boundary refers to the values of the absorbing boundaries at every time
step \eqn{t} in a diffusion model. In most cases, this will be a constant.
For instance:
\deqn{b(t) = b}
In this case, its derivative with respect to \eqn{t} is 0.

The default function when calling \code{drift_dm()} will be function for \code{b_fun}
returning a  numeric vector of length \code{length(t_vec)} containing the number
\eqn{0.5}. Its counterpart \code{dt_b} will return a numeric vector of the same
length containing its derivative, namely, \code{0}.
}

\subsection{Non-Decision Time:}{

The non-decision time refers to an additional time-requirement. Its
distribution across the time space will be convoluted with the PDFs derived
from the diffusion process.

In psychology, the non-decision time captures time-requirements outside the
central decision process, such as stimulus perception and motor execution.

The default function when calling \code{drift_dm()} returns a dirac
delta on  \eqn{t = 0.3}.
}
}
\note{
There is only a replacement function for \link{drift_dm} objects. This is
because replacing the component functions after the model has been fitted
(i.e., for a \code{fits_ids_dm} object) doesn't make sense.
}
\examples{
# get a pre-built model for demonstration
my_model <- ratcliff_dm()
names(comp_funs(my_model))

# direct replacement (see customize_ddms for a more information on
# how to write custom component functions)
# 1. Choose a uniform non-decision time from the pre-built component_shelf()
nt_uniform <- component_shelf()$nt_uniform
# swap it in
comp_funs(my_model)[["nt_fun"]] <- nt_uniform

# now update the flex_prms object to ensure that this model has the required
# parameters
prms <- c(muc = 3, b = 0.6, non_dec = 0.3, range_non_dec = 0.05)
conds <- "null"
new_flex_prms <- flex_prms(prms, conds = conds)
flex_prms(my_model) <- new_flex_prms

# accessor method also available for fits_ids_dm objects
# (see estimate_model_ids)
# get an exemplary fits_ids_dm object
fits <- get_example_fits("fits_ids_dm")
names(comp_funs(fits))

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}
}
