% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_bayes_estimate.R
\name{estimate_bayesian}
\alias{estimate_bayesian}
\title{(Hierarchical) Bayesian Estimation}
\usage{
estimate_bayesian(
  drift_dm_obj,
  obs_data_ids = NULL,
  sampler,
  n_chains,
  burn_in,
  samples,
  prob_migration,
  prob_re_eval,
  verbose = NULL,
  ...
)
}
\arguments{
\item{drift_dm_obj}{an object of type \link{drift_dm}.}

\item{obs_data_ids}{data.frame for the hierarchical case. An additional
column ID is necessary that codes the individuals (see also
\link{obs_data}).}

\item{sampler}{character string, indicating the sampler to use.
Must be either \code{"DE-MCMC"} (default) or \code{"TIDE"}.}

\item{n_chains}{numeric, number of chains for the MCMC-sampler.
Default is \code{40}.}

\item{burn_in}{numeric, number of burn-in iterations. Default is \code{500}.}

\item{samples}{numeric, number of sampling iterations after burn-in.
Default is \code{2000}.}

\item{prob_migration}{numeric, probability of performing a migration
crossover step during burn-in. Default is \code{0.1} (i.e., 10\%).}

\item{prob_re_eval}{numeric, probability of re-evaluating the
likelihood/posterior values of the previous iteration \code{i-1} when deciding
for the acceptance of the proposal in iteration \code{i}. Only considered during
burn-in. Default is \code{0.1} (i.e., 10\%).}

\item{verbose}{integer, indicating verbosity of output: 0 (none),
1 (minimal text output), or 2 (text output and progress bar). Default is \code{2}.}

\item{...}{additional arguments passed forward to
\code{\link[=estimate_bayes_h]{estimate_bayes_h()}} and \code{\link[=estimate_bayes_one_subj]{estimate_bayes_one_subj()}}.}
}
\value{
an object of type \code{mcmc_dm}  containing posterior samples for
parameters, log-posterior values, and log-likelihoods. In the hierarchical
case, the respective values are available at both the group-level and the
individual-level. The object contains two attributes: \code{sampler} and
\code{data_model}. The former simply stores the type of sampler that was used
and codes whether estimation was done in a hierarchical fashion or not.
The latter either contains the model and the attached data (in the
non-hierarchical case) or a named list of model copies with each
individual's data attached.
}
\description{
This function provides a wrapper around the implemented samplers for
Bayesian inference in dRiftDM. For parameter estimation,
Differential Evolution Markov-Chain Monte-Carlo (DE-MCMC)
\insertCite{Turneretal.2013;textual}{dRiftDM} is used.
An approximation of the marginal likelihood to calculate Bayes Factors can
be obtained with the Thermodynamic Integration via Differential Evolution
(TIDE) sampler \insertCite{EvansAnnis2019;textual}{dRiftDM}. However,
TIDE is not yet supported fully, and is at an experimental stage.
}
\details{
When a \link{data.frame} is supplied, a hierarchical approach to parameter
estimation is done. In this case, the supplied data set must provide data
for multiple individuals. To estimate the parameters for a single individual
(i.e., pursue the non-hierarchical approach), then the supplied model
\code{drift_dm_obj} must have data attached to it (see \code{\link[=obs_data]{obs_data()}}).
}
\references{
\insertRef{Turneretal.2013}{dRiftDM}
\insertRef{EvansAnnis2019}{dRiftDM}
}
\seealso{
\code{\link[=summary.mcmc_dm]{summary.mcmc_dm()}}, \code{\link[=estimate_bayes_h]{estimate_bayes_h()}},
\code{\link[=estimate_bayes_one_subj]{estimate_bayes_one_subj()}}
}
\keyword{internal}
