% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{prms_solve<-}
\alias{prms_solve<-}
\alias{prms_solve<-.drift_dm}
\alias{prms_solve}
\alias{prms_solve.drift_dm}
\alias{prms_solve.fits_ids_dm}
\alias{prms_solve.fits_agg_dm}
\title{The Parameters for Deriving Model Predictions}
\usage{
prms_solve(object, ...) <- value

\method{prms_solve}{drift_dm}(object, ..., eval_model = FALSE) <- value

prms_solve(object, ...)

\method{prms_solve}{drift_dm}(object, ...)

\method{prms_solve}{fits_ids_dm}(object, ...)

\method{prms_solve}{fits_agg_dm}(object, ...)
}
\arguments{
\item{object}{an object of type \link{drift_dm}, \code{fits_ids_dm}, or
\code{fits_agg_dm} (see \code{\link[=estimate_dm]{estimate_dm()}}).}

\item{...}{additional arguments (i.e., \code{eval_model}).}

\item{value}{a named numeric vector providing new values for the \code{prms_solve}
vector (see \code{\link[=drift_dm]{drift_dm()}}).}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not when updating the solver settings (see \link{re_evaluate_model}).
Default is \code{FALSE}.}
}
\value{
For \code{prms_solve()} the vector \code{prms_solve} (see \code{\link[=drift_dm]{drift_dm()}}).

For \verb{prms_solve<-()} the updated \link{drift_dm} object.
}
\description{
Functions to get or set the "solver settings" of an object. This includes the
diffusion constant and the discretization of the time and evidence space.
}
\details{
\code{prms_solve()} is a generic accessor function, and \verb{prms_solve<-()} is a
generic replacement function. The default methods get and set the "solver
settings".

It is possible to update parts of the "solver setttings" (i.e., parts of the
underlying \code{prms_solve} vector). However, modifying \code{"nx"} or \code{"nt"} is not
allowed! Any attempts to modify the respective entries will silently fail
(no explicit error/warning etc. is thrown).
}
\note{
There is only a replacement function for \link{drift_dm} objects. This is
because replacing the solver settings after the model has been fitted (e.g.,
for a \code{fits_ids_dm} object) doesn't make sense.
}
\examples{
# get some default model to demonstrate the prms_solve() functions
my_model <- ratcliff_dm()
# show the discretization and scaling of the model
prms_solve(my_model)
# partially modify these settings
prms_solve(my_model)[c("dx", "dt")] <- c(0.005)
prms_solve(my_model)

# accessor method also available for fits_ids_dm objects
# (see estimate_model_ids)
# get an exemplary fits_ids_dm object
fits <- get_example_fits("fits_ids_dm")
prms_solve(fits)

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}
}
