% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_cost_functions.R
\name{stats_from_pdfs_agg_info}
\alias{stats_from_pdfs_agg_info}
\title{Get Quantiles/CAFs from PDFs and stats_agg_info}
\usage{
stats_from_pdfs_agg_info(pdfs, t_vec, dt, stats_agg_info = NULL, what)
}
\arguments{
\item{pdfs}{named list of PDFs per condition, each containing elements
\code{pdf_u} and \code{pdf_l}.}

\item{t_vec}{numeric time vector.}

\item{dt}{numeric time step.}

\item{stats_agg_info}{list with information needed to compute summaries
(e.g., quantile probabilities or CAF bin counts; optional).}

\item{what}{character, one of \code{"quantiles"} or \code{"cafs"}, selecting which
statistic to compute.}
}
\value{
A list of numeric vectors, one per condition, containing the
predicted quantiles or CAFs. In case of failure, \code{NA_real_} values are
returned.
}
\description{
Internal helper to compute predicted summary statistics from condition-wise
PDFs, following the condition order. Calculates summary
statistics according to the information in \code{stats_agg_info}. Currently
supports either quantiles or conditional accuracy functions (CAFs).
}
\keyword{internal}
