% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_fits_ids_dm.R
\name{print.summary.fits_ids_dm}
\alias{print.summary.fits_ids_dm}
\alias{summary.fits_ids_dm}
\title{Summary and Printing for fits_ids_dm Objects}
\usage{
\method{print}{summary.fits_ids_dm}(x, ..., just_header = FALSE, round_digits = drift_dm_default_rounding())

\method{summary}{fits_ids_dm}(object, ..., select_unique = FALSE)
}
\arguments{
\item{x}{an object of class \code{summary.fits_ids_dm}.}

\item{...}{additional arguments (currently unused).}

\item{just_header}{logical, if \code{TRUE} only print the header information
without details. Default is \code{FALSE}.}

\item{round_digits}{an integer, specifying the number of decimal places for
rounding in the printed summary. Default is 3.}

\item{object}{an object of class \code{fits_ids_dm}, generated by a call
to \link{load_fits_ids}.}

\item{select_unique}{logical, passed to \code{\link[=coef.drift_dm]{coef.drift_dm()}}.}
}
\value{
\code{summary.fits_ids_dm()} returns a list of class \code{summary.fits_ids_dm} (see
the Details section summarizing each entry of this list).

\code{print.summary.fits_ids_dm()} returns invisibly the \code{summary.fits_ids_dm}
object.
}
\description{
Methods for summarizing and printing objects of the class \code{fits_ids_dm},
which contain multiple fits across individuals.
}
\details{
The \code{summary.fits_ids_dm} function creates a summary object. The contents of
this summary object depends on whether the user supplies a \code{fits_ids_dm}
object that was created with \code{\link[=estimate_dm]{estimate_dm()}} or the deprecated
function \code{\link[=load_fits_ids]{load_fits_ids()}}.
\itemize{
\item In the first case, the object contains:
\item \strong{summary_drift_dm_obj}: A list with information about the underlying
drift diffusion model (as returned by \code{\link[=summary.drift_dm]{summary.drift_dm()}}).
\item \strong{prms}: All parameter values across all conditions (essentially a call
to coef() with the argument select_unique = FALSE).
\item \strong{stats}: A named list of matrices for each condition, including mean and
standard error for each parameter.
\item \strong{obs_data}: A list providing the number of individual participants and
the average number of trials per condition across participants.
\item \strong{optimizer}: A string of the optimizer that was used
\item \strong{conv_info}: A list providing a summary of the convergance and messages
for all IDs
\item In the second case, the object contains:
\item \strong{lower} and \strong{upper}: Lower and upper bounds of the search space.
\item \strong{model_type}: Description of the model type, based on class information.
\item \strong{prms}: All parameter values across all conditions (essentially a call
to coef() with the argument select_unique = FALSE).
\item \strong{stats}: A named list of matrices for each condition, including mean and
standard error for each parameter.
\item \strong{N}: The number of individuals.
}

The \code{print.summary.fits_ids_dm} function displays the summary object in a
formatted manner.
}
\examples{
# get an auxiliary object of type fits_ids_dm for demonstration purpose
all_fits <- get_example_fits("fits_ids_dm")
sum_obj <- summary(all_fits)
print(sum_obj, round_digits = 2)

}
