% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processors.R
\name{get_processor_info}
\alias{get_processor_info}
\title{Get information about processor}
\usage{
get_processor_info(
  proc_id,
  proj_id = get_project_id(),
  loc = "eu",
  token = dai_token()
)
}
\arguments{
\item{proc_id}{a Document AI processor id.}

\item{proj_id}{a GCS project id.}

\item{loc}{a two-letter region code; "eu" or "us".}

\item{token}{an authentication token generated by
\code{dai_auth()} or another auth function.}
}
\value{
a list.
}
\description{
Get information about processor
}
\details{
Retrieves information about a processor. For more
information about processors, see the Google Document AI
documentation at
\url{https://docs.cloud.google.com/document-ai/docs}.
}
\examples{
\dontrun{
info <- get_processor_info()

info <- get_processor_info(proc_id = get_processors()$id[1])
}
}
