% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate.R
\name{merge_shards}
\alias{merge_shards}
\title{Merge shards}
\usage{
merge_shards(source_dir = getwd(), dest_dir = getwd())
}
\arguments{
\item{source_dir}{folder path for input files}

\item{dest_dir}{folder path for output files}
}
\value{
no return value, called for side effects
}
\description{
Merges text files from Document AI output shards into a
single text file corresponding to the parent document.
}
\details{
The function works on .txt files generated from .json output files,
not on .json files directly. It also presupposes that the .txt filenames
have the same name stems as the .json files from which they were extracted.
For the v1 API, this means files ending with "-0.txt", "-1.txt", "-2.txt",
and so forth. The safest approach is to generate .txt files using
\code{get_text()} with the \code{save_to_file} parameter set to TRUE.
}
\examples{
\dontrun{
merge_shards()

merge_shards(tempdir(), getwd())
}
}
