% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrimeFiles.R
\name{ListPrimeFiles}
\alias{ListPrimeFiles}
\title{List all downloadable code files from DataRobot Prime for the project}
\usage{
ListPrimeFiles(project, parentModelId = NULL, modelId = NULL)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{parentModelId}{numeric. Optional. Filter for only those prime files approximating this
parent model.}

\item{modelId}{numeric. Optional. Filter for only those prime files with code for this
prime model.}
}
\value{
List of lists. Each element of the list corresponds to one Prime file available to
  download. The elements of this list have the same format as the return value of GetPrimeFile.
}
\description{
Training a model using a ruleset is a necessary prerequisite for being able to download the code
for a ruleset.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  ListPrimeFiles(projectId)
}
}
