% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deployment.R
\name{ValidateReplaceDeployedModel}
\alias{ValidateReplaceDeployedModel}
\title{Validate a potential deployment model replacement.}
\usage{
ValidateReplaceDeployedModel(deploymentId, newModelId)
}
\arguments{
\item{deploymentId}{character. The ID of the deployment.}

\item{newModelId}{character. The ID of the model to use in the deployment. This model
will replace the old model. You can also pass a dataRobotModel object.}
}
\value{
A validation report with:
\itemize{
  \item status character. Either PASSED or FAILED depending on whether all checks passed
    or not.
  \item message character. A message explaining the status failure, if any.
  \item checks list. A list of each check and the individual status.
}
}
\description{
Validate a potential deployment model replacement.
}
\examples{
\dontrun{
  deploymentId <- "5e319d2e422fbd6b58a5edad"
  newModelId <- "5996f820af07fc605e81ead4"
  ValidateReplaceDeployedModel(deploymentId, newModelId)
}
}
