% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_numeric.R
\name{as_numeric}
\alias{as_numeric}
\alias{as_numeric.haven_labelled_defined}
\title{Coerce a defined vector to numeric}
\usage{
as_numeric(x, ...)

\method{as_numeric}{haven_labelled_defined}(x, strip_attributes = TRUE, ...)
}
\arguments{
\item{x}{A vector created with \code{\link[=defined]{defined()}}.}

\item{...}{Reserved for future use.}

\item{strip_attributes}{Logical; whether to remove semantic metadata
(\code{label}, \code{unit}, \code{concept}, \code{namespace}). Defaults to \code{TRUE}.}
}
\value{
A numeric vector with or without preserved attributes.
}
\description{
\code{as_numeric()} converts a \code{\link[=defined]{defined()}} vector to a numeric vector.
It validates that the underlying data are numeric, and optionally preserves
or strips semantic metadata.
}
\details{
Use \code{strip_attributes = TRUE} when flattening or preparing data for
external pipelines, but keep the default when working with defined
vectors directly.

\code{as.numeric()} drops all metadata and returns only the numeric values in
a vector.
}
\examples{
x <- defined(
     1:3,
     label = "Count",
     unit = "n",
     concept = "http://example.org/count",
     namespace = "http://example.org/ns"
)

as_numeric(x)

}
