% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contributor.R
\name{contributor}
\alias{contributor}
\alias{contributor<-}
\title{Get or set contributors}
\usage{
contributor(x)

contributor(x, overwrite = FALSE) <- value
}
\arguments{
\item{x}{A dataset object created with \code{\link[=dataset_df]{dataset_df()}} or \code{\link[=as_dataset_df]{as_dataset_df()}}.}

\item{overwrite}{Logical. If \code{TRUE}, replace all existing contributors with
\code{value}. If \code{FALSE}, append \code{value} to the existing contributors. Defaults
to \code{FALSE}.}

\item{value}{A \code{\link[utils:person]{utils::person}} object representing a single contributor. If
the \code{role} field is missing, it will be set to \code{"ctb"}. If \code{NULL}, the
dataset is returned unchanged.}
}
\value{
\itemize{
\item \code{contributor()} returns a \code{\link[utils:person]{utils::person}} or a list of such objects
corresponding to contributors.
\item \verb{contributor<-()} returns the updated dataset (invisibly).
}
}
\description{
\code{contributor()} is a lightweight wrapper around \code{\link[=creator]{creator()}} that
works only with contributors. It retrieves or updates only the contributor
entries in the dataset's bibliographic metadata.
}
\details{
All people are stored in the \code{author} slot of the underlying
\code{\link[utils:bibentry]{utils::bibentry}}. This helper preserves primary creators and filters or
updates only those entries that represent contributors.

A \emph{contributor} is defined as:
\itemize{
\item a person with \code{role == "ctb"}, \strong{or}
\item a person with a \code{comment[["contributorType"]]}.

Primary creators (authors) typically have \code{role \%in\% c("aut", "cre")}.

Contributors can be further annotated with metadata in \code{comment}, for
example:
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{comment = c(contributorType = "hostingInstitution", ORCID = "0000-0000-0000-0000")
}\if{html}{\out{</div>}}
}
\examples{
df <- dataset_df(data.frame(x = 1))
creator(df) <- person("Jane", "Doe", role = "aut")

# Add a contributor
contributor(df, overwrite = FALSE) <-
  person("GitHub",
    role = "ctb",
    comment = c(contributorType = "hostingInstitution")
  )

# Replace all contributors
contributor(df) <- person("Support", "Team", role = "ctb")

# Inspect only contributors
contributor(df)

}
\seealso{
Other bibliographic helper functions: 
\code{\link{creator}()},
\code{\link{dataset_format}()},
\code{\link{dataset_title}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{get_bibentry}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{relation}()},
\code{\link{rights}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
