% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_dublincore.R, R/dublincore.R
\name{as_dublincore}
\alias{as_dublincore}
\alias{dublincore}
\alias{is.dublincore}
\alias{print.dublincore}
\title{Add or Retrieve Dublin Core Metadata}
\source{
\itemize{
\item \href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/}{DCMI Metadata Terms}
}
}
\usage{
as_dublincore(x, type = "bibentry", ...)

dublincore(
  title,
  creator,
  contributor = NULL,
  year = NULL,
  publisher = NULL,
  identifier = NULL,
  subject = NULL,
  type = "DCMITYPE:Dataset",
  dataset_date = NULL,
  language = NULL,
  relation = NULL,
  dataset_format = "application/r-rds",
  rights = NULL,
  datasource = NULL,
  description = NULL,
  coverage = NULL
)

is.dublincore(x)

\method{print}{dublincore}(x, ...)
}
\arguments{
\item{x}{An object to test.}

\item{type}{The resource type. For datasets, use \code{"Dataset"}. See
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/}{DCMI Type Vocabulary}.}

\item{...}{Additional metadata fields.}

\item{title}{A name given to the resource. See \code{\link[=dataset_title]{dataset_title()}}.}

\item{creator}{One or more \code{\link[utils:person]{utils::person()}} objects representing the
creator(s). See \code{\link[=creator]{creator()}}.}

\item{contributor}{Additional contributors (\code{\link[utils:person]{utils::person()}}) with optional
roles. See \code{\link[=contributor]{contributor()}}.}

\item{year}{An explicit publication year. If omitted, inferred from
\code{dataset_date}.}

\item{publisher}{A character or \code{\link[utils:person]{utils::person()}} indicating the publishing
entity. See \code{\link[=publisher]{publisher()}}.}

\item{identifier}{A unique persistent identifier (e.g., DOI). See \code{\link[=identifier]{identifier()}}.}

\item{subject}{A keyword or controlled vocabulary term. See \code{\link[=subject]{subject()}} and
\code{\link[=subject_create]{subject_create()}}.}

\item{dataset_date}{A publication or release date (\code{Date}, \code{POSIXct}, or
character in \code{YYYY}, \code{YYYY-MM-DD}, or ISO format).}

\item{language}{ISO 639-1 language code. See \code{\link[=language]{language()}}.}

\item{relation}{A related resource (e.g., version, paper, or parent dataset).
Currently only supports an URI, for example,
\code{"https:://doi.org/10.32614/CRAN.package.dataset"}.}

\item{dataset_format}{The technical format of the dataset (e.g., MIME type).
See \code{\link[=dataset_format]{dataset_format()}}.}

\item{rights}{A string describing intellectual property or usage rights.
Use a URI like \code{"https://creativecommons.org/public-domain/cc0/"}.}

\item{datasource}{A URL or label for the original source of the dataset.}

\item{description}{A free-text summary of the dataset. See \code{\link[=description]{description()}}.}

\item{coverage}{Geographic or temporal extent (spatial/temporal coverage).}
}
\value{
A \code{bibentry} object extended with class \code{"bibrecord"}, storing structured
Dublin Core metadata. Use \code{\link[=as_dublincore]{as_dublincore()}} to extract the metadata in list,
tabular, or RDF form.

A logical value: \code{TRUE} if \code{x} is a Dublin Core metadata record (i.e.,
inherits from \code{"dublincore"}), otherwise \code{FALSE}.
}
\description{
Adds or retrieves metadata conforming to the
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/}{Dublin Core Metadata Terms}
standard, enabling consistent and structured citation and retrieval of R
dataset objects.

\code{is.dublincore()} checks whether an object inherits from the \code{"dublincore"}
class.
}
\details{
The Dublin Core Metadata Element Set (DCMES) is a standardized vocabulary for
describing digital and physical resources. It includes 15 core fields and is
formally standardized as ISO 15836, IETF RFC 5013, and ANSI/NISO Z39.85.

This function constructs a \code{\link[utils:bibentry]{utils::bibentry()}} object extended with DCMI
terms and is compatible with \code{\link[=dataset_df]{dataset_df()}} objects. The resulting metadata
can be used for semantic documentation and machine-readable citation.

For compatibility with \code{\link[utils:bibentry]{utils::bibentry()}}, the \code{dataset_date} parameter is
automatically used to derive both \code{publication_date} and \code{year} fields.
}
\examples{
orange_bibentry <- dublincore(
  title = "Growth of Orange Trees",
  creator = c(
    person(
      given = "N.R.",
      family = "Draper",
      role = "cre",
      comment = c(VIAF = "http://viaf.org/viaf/84585260")
    ),
    person(given = "H", family = "Smith", role = "cre")
  ),
  contributor = person(given = "Antal", family = "Daniel", role = "dtm"),
  publisher = "Wiley",
  datasource = "https://isbnsearch.org/isbn/9780471170822",
  dataset_date = 1998,
  identifier = "https://doi.org/10.5281/zenodo.14917851",
  language = "en",
  description = "The Orange data frame has 35 rows and 3 columns of records
                 of the growth of orange trees."
)

# To inspect structured metadata from a dataset_df object:
as_dublincore(orange_df, type = "list")

}
\seealso{
Learn more in the vignette:
\href{https://dataset.dataobservatory.eu/articles/bibrecord.html}{\code{bibrecord}}

Other bibrecord functions: 
\code{\link{as_datacite}()},
\code{\link{bibrecord}()}
}
\concept{bibrecord functions}
