% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-class-model-priors.R
\name{prior_tibble}
\alias{prior_tibble}
\title{Coerce a dcmprior object to a tibble}
\usage{
prior_tibble(x, ...)
}
\arguments{
\item{x}{A model specification (e.g., \code{\link[=dcm_specify]{dcm_specify()}}, measurement model
(e.g., \code{\link[=lcdm]{lcdm()}}), or structural model (e.g., \code{\link[=unconstrained]{unconstrained()}}) object.}

\item{...}{Additional arguments passed to methods. See details.}
}
\value{
A \link[tibble:tibble-package]{tibble} showing the specified priors.
}
\description{
When specifying prior distributions, it is often useful to see which
parameters are included in a given model. Using the Q-matrix and type of
diagnostic model to estimated, we can create a list of all included
parameters for which a prior can be specified.
}
\details{
Additional arguments passed to methods:

\code{.keep_all}: Logical indicating if all components should be returned. When
\code{FALSE} (the default), only the \verb{@type}, \verb{@coefficient}, and \verb{@prior}
elements of the \link[=prior]{dcmprior} object is return. When \code{TRUE}, the
\verb{@distribtuion}, \verb{@lower_bound}, and \verb{@upper_bound} are also returned.
}
\examples{
prior_tibble(default_dcm_priors(lcdm()))

prior_tibble(default_dcm_priors(dina(), independent()))
}
