% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_age.R
\name{plot_age}
\alias{plot_age}
\title{Title plot_age}
\usage{
plot_age(x, method, plot_type, line = FALSE)
}
\arguments{
\item{x}{A data frame containing unmodified \code{decomp_age()} output.}

\item{method}{Method used for age decomposition. Same as method argument in \code{decomp_age()}}

\item{plot_type}{Plot either total contribution in years or segmented effect contribution. Options: "total", "segment_dodge".}

\item{line}{Logical for additional line geom showing total effect if 'segment_dodge' \code{plot_type} is selected. FALSE by default. Not available for 'chandrasekaran1' and 'chandrasekaran2' methods.}
}
\value{
A \code{ggplot} object showing disease breakdown values
}
\description{
S3 method for \code{plot()} that visualizes age-related decomposition breakdowns from a data frame.
It pivots columns from \code{decomp_age()} output into a long format and creates a formatted bar plot.
}
\details{
Plot age decomposition breakdown
}
\examples{
age_output <- decomp_age(us_females,
  method = "arriaga3", age_col = "Age", e1 = "e1x",
  e2 = "e2x", l1 = "l1x", l2 = "l2x"
)

plot_age(age_output, method = "arriaga3", plot_type = "segment_dodge")
plot_age(age_output, method = "arriaga3", plot_type = "segment_dodge", line = TRUE)
plot_age(age_output, method = "arriaga3", plot_type = "total", line = TRUE)

}
