% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disclapmix_adaptive.R
\name{disclapmix_adaptive}
\alias{disclapmix_adaptive}
\title{Adaptive fitting}
\usage{
disclapmix_adaptive(
  x,
  label = "DL",
  margin = 5L,
  criteria = "BIC",
  init_y_generator = NULL,
  init_v_generator = NULL,
  ...
)
}
\arguments{
\item{x}{Dataset.}

\item{label}{A label}

\item{margin}{Fit models until there is at least this margin}

\item{criteria}{The slot to chose the best model from (BIC/AIC/AICc)}

\item{init_y_generator}{Function taking the number of clusters as input and returns `init_y` values}

\item{init_v_generator}{Function taking the number of clusters as input and returns `init_v` values}

\item{\dots}{Passed on to `disclapmix_robust()` (and further to `disclapmix()`)}
}
\value{
A list of all `disclapmix` fits
}
\description{
A wrapper around `disclapmix_robust()` that instead of fitting one model 
for a given number of clusters, fits models until the best model (lowest marginal BIC) 
is in the interior (with margin `M`) of all number of clusters tried.
}
\details{
E.g., the best model has 3 clusters and the margin `M = 5`, then 
this function ensures that models with 1, 2, ..., 3+5 = 8 clusters 
are fitted. If e.g. then 7 is better than 3, then it continues such that 
also models with up to 7+5 = 12 clusters are fitted. 

Note that models with 1-5 clusters are always fitted.
}
\examples{
data(danes)
db <- as.matrix(danes[rep(1:nrow(danes), danes$n), 1:(ncol(danes)-1)])
fits <- disclapmix_adaptive(db, margin = 5L)
fits
BICs <- sapply(fits, function(x) x$BIC_marginal)
BICs
ks <- sapply(fits, function(x) nrow(x$y)) # Always same as seq_along(fits)
ks
max_k <- max(ks)
best_k <- which.min(BICs)
max_k
best_k
max_k - best_k # = margin = 5
plot(ks, BICs, type = "b")

fits_clara <- disclapmix_adaptive(db, margin = 5L, init_y_method = "clara")

}
