% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{multi_event_true}
\alias{multi_event_true}
\title{Summarise multiple AESI-like events per treatment arm}
\usage{
multi_event_true(
  dt,
  event_vars,
  patient,
  treat,
  heading,
  label = NULL,
  .total_dt = NULL,
  indent = nbsp(n = 4L),
  pct_dec = 1
)
}
\arguments{
\item{dt}{A \code{data.frame} or \code{data.table} containing the binary event flags
and subject-level data.}

\item{event_vars}{A character vector of column names (binary flags) to
summarise.}

\item{patient}{A string giving the name of the variable that uniquely
identifies each patient (e.g., \code{"USUBJID"}).}

\item{treat}{A string giving the name of the treatment variable (e.g.,
\code{"ARM"}).}

\item{heading}{A string to be shown as the first row in the output, usually a
summary descriptor such as \code{"Total number of patients with at least one"}.}

\item{label}{Optional. A character vector of the same length as \code{event_vars}
giving human-readable labels for the output table rows. If \code{NULL}, labels
are extracted from the \code{label} attribute of each variable, or fall back to
the variable name.}

\item{.total_dt}{A \code{data.frame} or \code{data.table} containing the total analysis
population (denominator). If \code{NULL}, \code{dt} is used as the denominator.}

\item{indent}{A string to indent the row labels (e.g., \code{"  "} or \code{nbsp(n = 4L)} for non-breaking spaces).}

\item{pct_dec}{An integer indicating how many decimal places to show in
percentages (default is \code{1}).}
}
\value{
A one-element list containing a \code{data.table} with one row per event
plus one header row. The first column is \code{"stats"} (row labels), and
subsequent columns are one per treatment arm, with values in \code{"n (x\%)"}
format.
}
\description{
\code{multi_event_true()} generates a summary table showing the number and
percentage of patients with at least one event across multiple binary
indicator variables (e.g., flags for adverse events of special interest).
}
\details{
Each event is counted only once per patient. This function is typically used
for summarising \emph{Adverse Events of Special Interest} (AESIs) or other derived
flags (e.g., \code{SER}, \code{FATAL}, \code{RELDSM}) that are binary (TRUE/FALSE).
}
\examples{
aesi_vars <- c(
  "FATAL", "SER", "SERWD", "SERDSM", "RELSER",
  "WD", "DSM", "REL", "RELWD", "RELDSM", "SEV"
)

heading <- "Total number of patients with at least one AE"

multi_event_true(
  dt = aesi,
  event_vars = aesi_vars,
  patient = "USUBJID",
  treat = "ARM",
  heading = heading,
  .total_dt = adsl,
  indent = "  "
)[[1]]

}
\seealso{
\code{\link[=event_count]{event_count()}}, \code{\link[=total_events]{total_events()}}
}
