# Generated by 02-duckplyr_df-methods.R
#' @export
group_indices.duckplyr_df <- function(.data, ...) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    # Always fall back to dplyr
    "No relational implementation for {.code group_indices()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.data, duckplyr_error)

  group_indices <- dplyr$group_indices.data.frame
  out <- group_indices(.data, ...)
  return(out)

  # dplyr implementation
  if (dots_n(...) > 0) {
    lifecycle::deprecate_stop(
      "1.0.0",
      "group_indices(... = )",
      details = "Please `group_by()` first"
    )
    .data <- group_by(.data, ...)
  }

  # .Call(`dplyr_group_indices`, .data, group_rows(.data))
}

duckplyr_group_indices <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_indices(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
