% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_utils.R
\name{ddbs_create_schema}
\alias{ddbs_create_schema}
\title{Check and create schema}
\usage{
ddbs_create_schema(conn, name, quiet = FALSE)
}
\arguments{
\item{conn}{A connection object to a DuckDB database}

\item{name}{A character string with the name of the schema to be created}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
TRUE (invisibly) for successful schema creation
}
\description{
Check and create schema
}
\examples{
## load packages
\dontrun{
library(duckspatial)
library(duckdb)

## connect to in memory database
conn <- ddbs_create_conn(dbdir = "memory")

## create a new schema
ddbs_create_schema(conn, "new_schema")

## check schemas
dbGetQuery(conn, "SELECT * FROM information_schema.schemata;")

## disconnect from db
ddbs_stop_conn(conn)
}
}
