% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cv_pair_correlation.R
\name{plot_cv_pair_correlation}
\alias{plot_cv_pair_correlation}
\alias{plot_cv_pair_correlation.cv4abc}
\title{Plot CV parameter pair correlations}
\usage{
plot_cv_pair_correlation(data, ...)

\method{plot_cv_pair_correlation}{cv4abc}(data, ...)
}
\arguments{
\item{data}{A \code{cv4abc} object containing true parameters and
cross-validated estimates.}

\item{...}{Additional arguments:
\describe{
  \item{interactive}{Logical; whether to pause between tolerance levels and wait for input}
}}
}
\value{
Invisibly returns `NULL`. Called for its side effect of producing plots.
}
\description{
Create a matrix of pairwise plots for cross-validation parameter estimates,
including scatter plots with fitted trends, rank correlations, and marginal
distributions.
}
\examples{
# Load CV output from saved file
cv_file <- system.file(
  "extdata", "rdm_minimal", "abc", "cv", "neuralnet.rds",
  package = "eam"
)
abc_neuralnet_cv <- readRDS(cv_file)

# Plot parameter pair correlations
plot_cv_pair_correlation(abc_neuralnet_cv)

}
\seealso{
\code{\link{plot_cv_pair_correlation.cv4abc}}
}
