% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_models.R
\name{fit_models}
\alias{fit_models}
\title{Fit Survival Models}
\usage{
fit_models(
  data,
  time,
  event,
  predict_by = NULL,
  covariates = NULL,
  dists = c("exp", "gamma", "gengamma", "gompertz", "llogis", "lnorm", "weibull"),
  engine = "flexsurv",
  k = c(1, 2, 3),
  scale = "hazard",
  add_time_0 = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame containing the survival data.}

\item{time}{The name of the column in \code{data} containing the
time-to-event information.}

\item{event}{The name of the column in \code{data} indicating whether the
event of interest occurred.}

\item{predict_by}{(Optional) The name of the column in \code{data} defining
the prediction variable.}

\item{covariates}{(Optional) A character vector specifying the names of
covariates to be included in the model.}

\item{dists}{(Optional) A character vector specifying the distribution(s) to
be fitted.

When the engine parameter is set to "flexsurv", options are "exp",
"exponential", "gamma", "genf", "genf.orig", "gengamma", "gengamma.orig",
"gompertz", "llogis", "lnorm", "lognormal", "weibull", "weibullPH".

When the engine parameter is set to "flexsurvcure", options are "exp",
"gamma", "gengamma", "gompertz", "llogis", "lnorm", "weibull".

When the engine parameter is set to "flexsurvspline", dists are ignored in
favor of k and scale parameters.

When the engine parameter is set to "survival", options are "exponential",
"extreme", "gaussian", "loggaussian" (same as lognormal), "logistic",
"lognormal", "rayleigh", "weibull".

Default is \code{c("exp", "gamma", "gengamma", "gompertz",
  "llogis", "lnorm", "weibull")} which applies to flexsurv-related engines.}

\item{engine}{(Optional) The survival analysis engine to be used.
Options are "flexsurv", "flexsurvcure", "flexsurvspline", and "survival".
Default is "flexsurv".

\itemize{
\item "flexsurv" uses \code{\link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg()}}.
\item "flexsurvspline" uses \code{\link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline()}}.
\item "flexsurvcure" uses \code{\link[flexsurvcure:flexsurvcure]{flexsurvcure::flexsurvcure()}}.
\item "survival" uses \code{\link[survival:survreg]{survival::survreg()}}.
}}

\item{k}{(Optional) A numeric vector specifying the number of knots for
spline-based models. Default is \code{c(1, 2, 3)} to test different
numbers.}

\item{scale}{(Optional) A character vector specifying the scale parameter(s)
for spline-based models. Options are "hazard", "odds", and "normal".
Default is \code{"hazard"}.}

\item{add_time_0}{Optional. Uses \code{\link[survival:survfit0]{survival::survfit0()}} to add a starting
time of 0 to the KM survfit object. This may be useful for plotting the KM
at a subsequent stage (in surv_plots). Default is TRUE.}

\item{...}{Additional arguments just to catch them and avoid errors.}
}
\value{
A list containing information about the fit_models() call, the
distributions attempted, goodness of fit, fit averages, and cure fractions
(if applicable).
}
\description{
Fits survival models to the provided data using the specified engine and
returns various outputs including model parameters, goodness of fit, and
estimates of median survival.
}
\examples{
models <- fit_models(
  data = easysurv::easy_bc,
  time = "recyrs",
  event = "censrec",
  predict_by = "group",
  covariates = "group"
)

models
}
