% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{edge_simd_info}
\alias{edge_simd_info}
\title{Query SIMD optimization status}
\usage{
edge_simd_info()
}
\value{
List with:
\describe{
\item{architecture}{CPU architecture (e.g., "x86_64", "aarch64")}
\item{compiler_features}{Character vector of compiler-detected SIMD features}
\item{ggml_features}{Character vector of GGML-level optimization flags}
\item{is_generic}{Logical; TRUE if compiled with generic (scalar) fallback}
}
}
\description{
Reports which SIMD (Single Instruction Multiple Data) features were enabled
at compile time. This helps verify that the package is using CPU-optimized
code paths for faster inference.
}
\examples{
info <- edge_simd_info()
cat("Architecture:", info$architecture, "\n")
cat("SIMD features:", paste(info$compiler_features, collapse = ", "), "\n")
if (info$is_generic) {
  cat("Running in generic mode. Reinstall with EDGEMODELR_SIMD=AVX2 for better performance.\n")
}
}
