% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Firth_regression.R
\name{run_firth_regression}
\alias{run_firth_regression}
\title{Firth Penalized Logistic Regression for Drug Cocktails}
\usage{
run_firth_regression(
  cocktail,
  upper_bound,
  patient_data,
  adr_column = "patientADR"
)
}
\arguments{
\item{cocktail}{An integer vector representing the ATC indices of drugs in the combination.}

\item{upper_bound}{A list or vector defining the hierarchy/bounds (upper_bound column of the ATC_tree).}

\item{patient_data}{A data frame containing patient-level data, including the ADR outcome.}

\item{adr_column}{A string specifying the column name in \code{patient_data} used as the dependent variable (Y). 
Defaults to "patientADR".}
}
\value{
An object of class \code{logistf} containing the regression results, including 
  coefficients, p-values, and confidence intervals.
}
\description{
This function prepares a specific "cocktail" (a set of drugs) 
and performs a Firth's penalized logistic regression to estimate the interaction 
effect between the drug present in the combination detected as "at risk".
}
\details{
Firth's method is preferred here as it handles 
"separation" issues common in sparse clinical data (where a drug combination 
might perfectly predict an ADR).
}
\examples{
\dontrun{
# Example using indices for drugs 888, 659
results <- run_firth_regression(
  cocktail = c(888, 659),
  upper_bound = ATC_Tree_UpperBound_2024$upperBound,
  patient_data = FAERS_myopathy
)
summary(results)
}

}
