% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csem_info.R
\name{csem_info}
\alias{csem_info}
\title{CSEM of IRT Model via Information}
\usage{
csem_info(theta, ip, est = c("MLE", "EAP"))
}
\arguments{
\item{theta}{A numeric vector (or object coercible to a numeric vector)
containing the ability values at which to compute CSEM.}

\item{ip}{A data frame or matrix of item parameters. Columns are interpreted
in the same way as in \code{info()}:
\itemize{
\item 3 columns: \code{b}, \code{a}, \code{c} (3PL; \code{a} on the \code{D = 1.702} metric),
\item 2 columns: \code{b}, \code{a} (2PL; \code{c} internally set to 0),
\item 1 column: \code{b} (1PL/Rasch; \code{a = 1}, \code{c = 0}).
}}

\item{est}{A character string specifying the estimation method:
\code{"MLE"} for maximum likelihood or \code{"EAP"} for empirical Bayes.}
}
\value{
A list containing:
\itemize{
\item \code{theta} — vector of ability values.
\item \code{csemMLE} — CSEM values for MLE (if \code{est = "MLE"}).
\item \code{csemEAP} — CSEM values for EAP (if \code{est = "EAP"}).
}
}
\description{
Compute the CSEM for a unidimensional IRT model using either MLE- or EAP-based test information.
}
