% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scc_class.R
\name{new_scc}
\alias{new_scc}
\alias{validate_scc}
\alias{empty_scc}
\alias{print.epicmodel_scc}
\alias{summary.epicmodel_scc}
\alias{plot.epicmodel_scc}
\title{SCC model objects}
\usage{
new_scc(x = list())

validate_scc(x)

empty_scc()

\method{print}{epicmodel_scc}(x, ...)

\method{summary}{epicmodel_scc}(object, ...)

\method{plot}{epicmodel_scc}(
  x,
  remove_sc = NULL,
  sc_label = NULL,
  unknown = TRUE,
  names = TRUE,
  text_color = NULL,
  pie_color = NULL,
  border_color = NULL,
  ...
)
}
\arguments{
\item{x}{\code{x} is used in several functions:
\itemize{
\item \code{new_scc()}: A list to be converted to class \code{epicmodel_scc}.
\item \code{validate_scc()}: An object of class \code{epicmodel_scc} to be validated.
\item \code{print.epicmodel_scc()}: An object of class \code{epicmodel_scc}.
\item \code{plot.epicmodel_scc()}: An object of class \code{epicmodel_scc}.
}}

\item{...}{Additional arguments for generics \code{print()}, \code{summary()}, and \code{plot()}.}

\item{object}{For \code{summary.epicmodel_scc()}, an object of class \code{epicmodel_scc}.}

\item{remove_sc}{For \code{plot.epicmodel_scc()}, a vector of integerish numbers, i.e., integers that can be specified as numeric, i.e., \code{1} and \code{1L}
are both possible. Removes the sufficient cause (SC) with the specified index from the plot, i.e., for \code{remove_sc = 2}, removes SC 2, and for
\code{remove_sc = c(2,3)}, removes SC 2 and SC 3. If there are x sufficient causes in the model, x is the highest allowed value. At least one
sufficient cause needs to remain, i.e., not all sufficient causes can be removed. If NULL (default), all sufficient causes are plotted.}

\item{sc_label}{For \code{plot.epicmodel_scc()}, a character vector with the labels written above the pies, i.e., sufficient causes. If NULL
(default), "Sufficient Cause 1", "Sufficient Cause 2", etc. are used. If specified, try to provide as many labels as there are pies in the plot.
Duplicates are not allowed.}

\item{unknown}{For \code{plot.epicmodel_scc()}, TRUE (default) or FALSE. If TRUE, unknown causes are added to the SCC model: every sufficient cause
gets an additional individual unknown component cause representing additional unknown components; an unknown sufficient cause is added to
the model consisting of a single unknown component cause and representing all unknown sufficient causes.}

\item{names}{For \code{plot.epicmodel_scc()}, TRUE (default) or FALSE. If TRUE, includes the translation of pie segment names to descriptions of
component causes in the plot.}

\item{text_color}{For \code{plot.epicmodel_scc()}, a single element of type character, which is a valid color description. Valid color descriptions
can be named colors ("white") or hexadecimal color codes ("#FFFFFF"). \code{text_color} will be used for the pie segment names. If NULL (default),
"white" is used.}

\item{pie_color}{For \code{plot.epicmodel_scc()}, a character vector of length 3 containing valid color descriptions. Valid color descriptions
can be named colors ("white") or hexadecimal color codes ("#FFFFFF"). The first element of \code{pie_color} is used to color sufficient causes,
which are always sufficient. The second element is used to color sufficient causes, for which sufficiency depends on the order of occurrence.
The third element is used to color the unknown sufficient cause, which is present if \code{unknown} is TRUE. If NULL (default), the following colors
are used: "#B1934A", "#A65141", "#394165"}

\item{border_color}{For \code{plot.epicmodel_scc()}, a single element of type character, which is a valid color description. Valid color
descriptions can be named colors ("white") or hexadecimal color codes ("#FFFFFF"). \code{border_color} will be used for all pie borders apart from
the unknown sufficient cause. Therefore, only specify \code{border_color} if \code{unknown} is FALSE. If NULL (default), "white" is used. (Borders
for the unknown sufficient cause have the same color as the pie.)}
}
\value{
\itemize{
\item \code{new_scc()}: An object of class \code{epicmodel_scc}.
\item \code{validate_scc()}: An object of class \code{epicmodel_scc} that has been checked to have the correct structure.
\item \code{empty_scc()}: A (realtively) empty object of class \code{epicmodel_scc} with correct structure.
\item \code{print.epicmodel_scc()}: Prints a summary of the object of class \code{epicmodel_scc} in the console.
\item \code{summary.epicmodel_scc()}: Same as \code{print.epicmodel_scc()}.
\item \code{plot.epicmodel_scc()}: A \code{ggplot} object.
}
}
\description{
The S3 class \code{epicmodel_scc} is used to store information on sufficient-component cause (SCC) models created by \code{\link[=create_scc]{create_scc()}}.

\code{new_scc()}, \code{validate_scc()}, and \code{empty_scc()} define the S3 class.

\code{print()} prints a summary of SCC models in the console. \code{summary()} and \code{print()} are identical.

\code{plot()} creates the familiar causal pie charts from an object of class \code{epicmodel_scc}.
}
\details{
\subsection{\code{epicmodel_scc} objects}{

\code{epicmodel_scc} objects are lists containing 10 elements. These elements are described below:
\describe{
\item{\code{sc_cc}}{A data.frame with one column for every component cause and one row for every sufficient cause. Colnames are the step IDs from
the corresponding steplist. Rownames are sufficient cause IDs (see below). Each cell contains either TRUE or FALSE indicating if the component
cause in the column is part of a set of component causes described by the row.}

\item{\code{sc_status}}{A named character vector with one element for every sufficient cause. The names are sufficient cause IDs (see below). The
elements contain the status of the sufficient cause (see below). Here, only "always", "depends", and "depends (potential order
implausibilities)" appear.}

\item{\code{sc_steps}}{A list of character vectors with one list element for every sufficient cause. The list is named using sufficient cause IDs
(see below). Every character vector contains the step IDs of all steps that are part of the corresponding sufficient cause, i.e., that can be
caused by the corresponding set of component causes.}

\item{\code{sc_order}}{A list with one list element for every sufficient cause. The list is named using sufficient cause IDs (see below). List
elements are either NA (if a sufficient cause's status is "always") or a data.frame (if a sufficient cause's status is "depends" or "depends
(potential order implausibilities)". Data.frames contain two columns, which are called "order" and "suff" (short for "sufficient"), and one row
for every order of occurrence. The order of occurrence is summarized in "order" (as character), while "suff" is either TRUE or FALSE indicating
if the corresponding order of occurrence is sufficient, i.e., leads to the outcome, or not.}

\item{\code{sc_implausibilities}}{A named vector of TRUE and FALSE with length equal to the number of sufficient causes. The names are sufficient
cause IDs (see below). Is TRUE if for the corresponding sufficient cause there are potential order implausibilities, i.e., if its status is
"depends (potential order implausibilities)", and is FALSE otherwise.}

\item{\code{sc_implausibilities_detail}}{A list with one list element for every sufficient cause. The list is named using sufficient cause IDs
(see below). List elements are either NA (if the corresponding element in \code{sc_implausibilities} is FALSE) or a character vector (if the
corresponding element in \code{sc_implausibilities} is TRUE) with the THEN statements of the steps that might be involved in implausible orders of
occurrence.}

\item{\code{sc_use_modules}}{Either TRUE or FALSE indicating if modules have been specified in the steplist.}

\item{\code{unknown_cc}}{Similar to \code{sc_cc} but includes unknown component causes and an unknown sufficient cause (see "Unknown causes" below).
It therefore additionally contains:
\itemize{
\item one column to the right for every sufficient cause with name "U\code{rownumber}" (U1, U2, etc.) and all values equal to FALSE appart from row
\code{rownumber}, which is TRUE
\item one additional column to the right with name "USC" and all values equal to FALSE for all sufficient causes
\item one additional row with name "cc0" and all values equal to FALSE apart from column "USC", which is TRUE}
}

\item{\code{unknown_status}}{Similar to \code{sc_status} but has one additional element with value "unknown" and name "cc0" (see "Unknown causes" below).}

\item{\code{steplist}}{The object of class \code{epicmodel_steplist_checked} that has been the input to function \code{\link[=create_scc]{create_scc()}}, from which the
\code{epicmodel_scc} object has been created.}
}
}

\subsection{Other details:}{

\describe{
\item{\verb{Sufficient cause IDs}}{\code{\link[=create_scc]{create_scc()}} checks every combination of component causes for sufficiency. Every combination is assigned an
ID of the format "cc\code{number}" (cc1, cc2, etc.). \code{epicmodel_scc} only contains information about minimally sufficient combinations of component
causes, but the initial IDs are kept. The IDs are used throughout the different elements of \code{epicmodel_scc} to link information that belongs to
the same sufficient cause. The unknown sufficient cause used in elements \code{unknown_cc} and \code{unknown_status} has ID cc0.}

\item{\verb{Unknown causes}}{Since many causes might be unknown, it is reasonable for some applications to include these unknown causes in a SCC
model (see, e.g., Rothman et al. (2008)). They are also useful to remind us of our limited knowledge. In a suffcient-component cause model,
unknown causes come in two flavors:
\itemize{
\item \verb{Unknown component causes}: These are additional component causes within a sufficient cause, which are necessary for sufficiency. Please note
that each sufficient cause has its own set of unknown component causes. In \code{unknown_cc}, unknown component causes are called U1, U2, etc.
\item \verb{Unknown sufficient causes}: There might be unknown mechanisms that lead to outcome occurrence. These sufficient causes are summarized in one
additional sufficient cause, which has only a single component cause called \code{USC} in \code{unknown_cc}. This set of component causes has
sufficient cause ID \code{cc0}.
}

Please note that in \code{\link[=plot_dag]{plot_dag()}} an ellipse represents a \strong{determinative set} of sufficient causes, as suggested and defined by VanderWeele &
Robins (2007). A determinative set contains all sufficient causes and, therefore, in most cases, an unknown sufficient cause is necessary to
at least achieve a theoretical determinative set. Determinative sets are important for creating causal diagrams (in the form of directed
acyclic graphs) from SCC models. VanderWeele and Robins (2007) write (p. 1099, D refers to the outcome):

\emph{"To ensure that the DAG with the sufficient causation structure is itself a causal DAG, it is important that the set of sufficient causes for}
\emph{D on the graph be a determinative set of sufficient causes — that is, that the sufficient causes represent all of the pathways by which the}
\emph{outcome D may occur. Otherwise certain nodes may have common causes which are not on the graph, and the graph will then not be a causal DAG."}

It can of course be argued that an unknown sufficient cause in the described form is hardly of any use when creating a causal graph (as a DAG)
from a SCC model. Nonetheless, it can be, as mentioned, a placeholder and reminder of limited knowledge.
}

\item{\verb{Sufficiency status}}{The sufficiency status describes under which circumstances a certain set of component causes is sufficient. There
are 5 possible values:
\itemize{
\item \code{always}: The set of component causes is always sufficient.
\item \code{depends}: The set of component causes is sometimes sufficient and sufficiency depends on the order of occurrence of the involved steps,
because some of them contain IFNOT conditions. However, if an IFNOT condition prevents the step from happening depends on the order of
occurrence: if the IF condition is fulfilled before the IFNOT condition, the step (usually) occurs anyways, similar to how I do not care if
a door is closed if I already went through it when it was still open.
\item \verb{depends (potential order implausibilities)}: Same as "depends", but in the list of potential orders of occurrence of the involved steps,
there might be some that do not make sense in practice, e.g., when two steps with IFNOT conditions are chained together: Imagine Step1
having IF condition If1 and IFNOT condition Ifnot1, and Step2 having IF condition If2 and IFNOT condition Step1. The order Step1 -> Ifnot1
-> If1 -> If2 is not plausible because Ifnot1 occurred before If1 and therefore Step1 did never occur. The user needs to discard these orders
of occurrence (as I am currently not confident to correctly remove only implausible ones with code).
\item \code{never}: The set of component causes is never sufficient. This status is not used in \code{epicmodel_scc}. It's only used when investigating the
effect of interventions (see \code{\link[=intervene]{intervene()}}).
\item \code{unknown}: This is the status of the unknown sufficient cause, which is added to the SCC model. It's only used in element \code{unknown_status} of
\code{epicmodel_scc} objects.}
}
}
}
}
\examples{
# epicmodel_scc object are created by create_scc()

# first, check your steplist of choice
steplist_checked <- check_steplist(steplist_rain)
# then, use it in create_scc()
scc_model <- create_scc(steplist_checked)

# new_scc() and validate_scc() are used inside create_scc()
# nonetheless, you can check its structure with validate_scc()
validate_scc(scc_model)

# print() and summary() both summarize the model in the console
print(scc_model)
scc_model
summary(scc_model)

# plot causal pies with plot()
plot(scc_model)

}
\references{
\itemize{
\item Rothman KJ, Greenland S, Poole C, Lash TL (2008): Causation and Causal Inference. In: Rothman KJ, Greenland S, Lash TL (Ed.): Modern
epidemiology. Third edition. Philadelphia, Baltimore, New York: Wolters Kluwer Health Lippincott Williams & Wilkins, pp. 5–31.
\item VanderWeele TJ, Robins JM (2007): Directed acyclic graphs, sufficient causes, and the properties of conditioning on
a common effect. American Journal of Epidemiology 166 (9): 1096–1104.
}
}
\seealso{
\itemize{
\item \code{\link[=create_scc]{create_scc()}} for information on the algorithm for creating SCC models
\item \code{\link[=plot_dag]{plot_dag()}} for how determinative sets of component causes are displayed in a DAG
\item \code{\link[=intervene]{intervene()}} for the use of sufficiency status "never"
}
}
